/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCStation<S extends CommonDockStation<?, ?>>
implements CStation<S> {
    private CLocation location;
    private String id;
    private S station;
    private CControlAccess control;

    public AbstractCStation(S station, String id, CLocation location) {
        this.init(station, id, location);
    }

    protected AbstractCStation() {
    }

    protected void init(S station, String id, CLocation location) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        this.station = station;
        this.id = id;
        this.location = location;
    }

    @Override
    public CLocation getStationLocation() {
        return this.location;
    }

    @Override
    public CLocation getDropLocation() {
        if (this.control == null) {
            return null;
        }
        return this.control.getLocationManager().getDropLocation(this);
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public S getStation() {
        return this.station;
    }

    @Override
    public void setControlAccess(CControlAccess access) {
        if (this.control != access) {
            if (this.control != null) {
                this.uninstall(this.control);
            }
            this.control = access;
            if (this.control != null) {
                this.install(this.control);
            }
        }
    }

    protected CControlAccess getControl() {
        return this.control;
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    @Override
    public CDockable asDockable() {
        return null;
    }

    protected abstract void install(CControlAccess var1);

    protected abstract void uninstall(CControlAccess var1);
}

