/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.grouping;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.grouping.CGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.support.mode.HistoryRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingHistoryRewriter
implements HistoryRewriter<Location, CLocationMode> {
    private CControl control;
    private HistoryRewriter<Location, CLocationMode> validation;

    public GroupingHistoryRewriter(CControl control, HistoryRewriter<Location, CLocationMode> validation) {
        this.control = control;
        this.validation = validation;
    }

    @Override
    public Location rewrite(Dockable dockable, CLocationMode mode, Location history) {
        if (history != null && history.isApplicationDefined()) {
            return this.validation.rewrite(dockable, mode, history);
        }
        CGroupingBehavior groupingBehavior = this.control.getProperty(CControl.GROUPING_BEHAVIOR);
        DockableGrouping grouping = groupingBehavior.getGrouping(dockable);
        if (grouping == null) {
            return this.validation.rewrite(dockable, mode, history);
        }
        Location result = history;
        result = grouping.getStoredLocation(dockable, mode, result);
        result = this.validation.rewrite(dockable, mode, result);
        result = grouping.getValidatedLocation(dockable, mode, result);
        return result;
    }
}

