/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.vpda;

import net.automatalib.automata.vpda.DefaultOneSEVPA;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.commons.util.Pair;
import net.automatalib.util.automata.vpda.ProductOneSEVPA;
import net.automatalib.util.minimizer.OneSEVPAMinimizer;
import net.automatalib.util.ts.acceptors.AcceptanceCombiner;
import net.automatalib.words.VPDAlphabet;

public final class OneSEVPAs {
    private OneSEVPAs() {
        throw new IllegalStateException("Constructor should never be invoked");
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> and(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.AND);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> combine(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPDAlphabet<I> alphabet, AcceptanceCombiner combiner) {
        return new ProductOneSEVPA<L1, L2, I>(alphabet, sevpa1, sevpa2, combiner);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> or(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.OR);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> xor(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.XOR);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> equiv(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.EQUIV);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> impl(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.IMPL);
    }

    public static <I> DefaultOneSEVPA<I> minimize(OneSEVPA<?, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAMinimizer.minimize(sevpa, alphabet);
    }
}

