/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.ads;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.KeyFor;

class SplitTree<S, I, O> {
    private final Map<O, SplitTree<S, I, O>> successors;
    private final Map<S, S> mapping;
    private final Set<S> partition;
    private Word<I> sequence;

    SplitTree(Set<S> partition) {
        this.partition = partition;
        this.successors = new HashMap<O, SplitTree<S, I, O>>();
        this.mapping = new HashMap<S, S>();
        this.sequence = Word.epsilon();
    }

    public Map<O, SplitTree<S, I, O>> getSuccessors() {
        return this.successors;
    }

    public Map<S, S> getMapping() {
        return this.mapping;
    }

    public Set<@KeyFor(value={"partition"}) S> getPartition() {
        return this.partition;
    }

    public Word<I> getSequence() {
        return this.sequence;
    }

    public void setSequence(Word<I> sequence) {
        this.sequence = sequence;
    }

    public Optional<SplitTree<S, I, O>> findLowestSubsetNode(Set<S> nodes) {
        for (SplitTree<S, I, O> st : this.successors.values()) {
            Optional<SplitTree<S, I, O>> candidate = st.findLowestSubsetNode(nodes);
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        if (this.partition.containsAll(nodes)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public String toString() {
        return String.format("[states: %s, seq=%s]", this.partition.toString(), this.sequence.toString());
    }
}

