/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.fsa.MutableFSA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.automata.transducers.MutableMealyMachine;
import net.automatalib.automata.transducers.MutableMooreMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.automata.transducers.impl.compact.CompactMoore;
import net.automatalib.commons.util.Pair;
import net.automatalib.graphs.MutableGraph;
import net.automatalib.graphs.base.compact.CompactGraph;
import net.automatalib.serialization.InputModelDeserializer;
import net.automatalib.serialization.ModelDeserializer;
import net.automatalib.serialization.dot.DOTGraphParser;
import net.automatalib.serialization.dot.DOTMutableAutomatonParser;
import net.automatalib.serialization.dot.GraphDOT;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DOTParsers {
    public static final Function<Map<String, String>, @Nullable String> DEFAULT_NODE_PARSER = attr -> (String)attr.get("label");
    public static final Function<Map<String, String>, Boolean> DEFAULT_FSA_NODE_PARSER = attr -> "doublecircle".equals(attr.get("shape"));
    public static final Function<Map<String, String>, @Nullable String> DEFAULT_MOORE_NODE_PARSER = attr -> {
        String label = (String)attr.get("label");
        if (label == null) {
            return null;
        }
        String[] tokens = label.split("/");
        if (tokens.length != 2) {
            return null;
        }
        return tokens[1].trim();
    };
    public static final Function<Map<String, String>, @Nullable String> DEFAULT_EDGE_PARSER = attr -> (String)attr.get("label");
    public static final Function<Map<String, String>, Pair<@Nullable String, @Nullable String>> DEFAULT_MEALY_EDGE_PARSER = attr -> {
        String label = (String)attr.get("label");
        if (label == null) {
            return Pair.of(null, null);
        }
        String[] tokens = label.split("/");
        if (tokens.length != 2) {
            return Pair.of(null, null);
        }
        return Pair.of(tokens[0].trim(), tokens[1].trim());
    };

    private DOTParsers() {
    }

    public static InputModelDeserializer<@Nullable String, CompactDFA<@Nullable String>> dfa() {
        return DOTParsers.dfa(DEFAULT_FSA_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <I> InputModelDeserializer<I, CompactDFA<I>> dfa(Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.fsa(new CompactDFA.Creator(), nodeParser, edgeParser);
    }

    public static InputModelDeserializer<@Nullable String, CompactNFA<@Nullable String>> nfa() {
        return DOTParsers.nfa(DEFAULT_FSA_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <I> InputModelDeserializer<I, CompactNFA<I>> nfa(Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.fsa(new CompactNFA.Creator(), nodeParser, edgeParser);
    }

    public static <I, A extends MutableFSA<?, I>> InputModelDeserializer<I, A> fsa(AutomatonCreator<A, I> creator, Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.fsa(creator, nodeParser, edgeParser, Collections.singleton(GraphDOT.initialLabel(0)));
    }

    public static <I, A extends MutableFSA<?, I>> InputModelDeserializer<I, A> fsa(AutomatonCreator<A, I> creator, Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser, Collection<String> initialNodeIds) {
        return DOTParsers.fsa(creator, nodeParser, edgeParser, initialNodeIds, true);
    }

    public static <I, A extends MutableFSA<?, I>> InputModelDeserializer<I, A> fsa(AutomatonCreator<A, I> creator, Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser, Collection<String> initialNodeIds, boolean fakeInitialNodeIds) {
        return new DOTMutableAutomatonParser(creator, nodeParser, edge -> Pair.of(edgeParser.apply((Map<String, String>)edge), null), initialNodeIds, fakeInitialNodeIds);
    }

    public static InputModelDeserializer<@Nullable String, CompactMealy<@Nullable String, @Nullable String>> mealy() {
        return DOTParsers.mealy(DEFAULT_MEALY_EDGE_PARSER);
    }

    public static <I, O> InputModelDeserializer<I, CompactMealy<I, O>> mealy(Function<Map<String, String>, Pair<I, O>> edgeParser) {
        return DOTParsers.mealy(new CompactMealy.Creator(), edgeParser);
    }

    public static <I, O, A extends MutableMealyMachine<?, I, ?, O>> InputModelDeserializer<I, A> mealy(AutomatonCreator<A, I> creator, Function<Map<String, String>, Pair<I, O>> edgeParser) {
        return DOTParsers.mealy(creator, edgeParser, GraphDOT.initialLabel(0));
    }

    public static <I, O, A extends MutableMealyMachine<?, I, ?, O>> InputModelDeserializer<I, A> mealy(AutomatonCreator<A, I> creator, Function<Map<String, String>, Pair<I, O>> edgeParser, String initialNodeId) {
        return DOTParsers.mealy(creator, edgeParser, initialNodeId, true);
    }

    public static <I, O, A extends MutableMealyMachine<?, I, ?, O>> InputModelDeserializer<I, A> mealy(AutomatonCreator<A, I> creator, Function<Map<String, String>, Pair<I, O>> edgeParser, String initialNodeId, boolean fakeInitialNodeId) {
        return new DOTMutableAutomatonParser(creator, node -> null, edgeParser, Collections.singleton(initialNodeId), fakeInitialNodeId);
    }

    public static InputModelDeserializer<@Nullable String, CompactMoore<@Nullable String, @Nullable String>> moore() {
        return DOTParsers.moore(DEFAULT_MOORE_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <I, O> InputModelDeserializer<I, CompactMoore<I, O>> moore(Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.moore(new CompactMoore.Creator(), nodeParser, edgeParser);
    }

    public static <I, O, A extends MutableMooreMachine<?, I, ?, O>> InputModelDeserializer<I, A> moore(AutomatonCreator<A, I> creator, Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.moore(creator, nodeParser, edgeParser, GraphDOT.initialLabel(0));
    }

    public static <I, O, A extends MutableMooreMachine<?, I, ?, O>> InputModelDeserializer<I, A> moore(AutomatonCreator<A, I> creator, Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser, String initialNodeId) {
        return DOTParsers.moore(creator, nodeParser, edgeParser, initialNodeId, true);
    }

    public static <I, O, A extends MutableMooreMachine<?, I, ?, O>> InputModelDeserializer<I, A> moore(AutomatonCreator<A, I> creator, Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser, String initialNodeId, boolean fakeInitialNodeId) {
        return new DOTMutableAutomatonParser(creator, nodeParser, edge -> Pair.of(edgeParser.apply((Map<String, String>)edge), null), Collections.singleton(initialNodeId), fakeInitialNodeId);
    }

    public static ModelDeserializer<CompactGraph<@Nullable String, @Nullable String>> graph() {
        return DOTParsers.graph(DEFAULT_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <NP, EP> ModelDeserializer<CompactGraph<NP, EP>> graph(Function<Map<String, String>, NP> nodeParser, Function<Map<String, String>, EP> edgeParser) {
        return DOTParsers.graph(CompactGraph::new, nodeParser, edgeParser);
    }

    public static <NP, EP, G extends MutableGraph<?, ?, NP, EP>> ModelDeserializer<G> graph(Supplier<G> creator, Function<Map<String, String>, NP> nodeParser, Function<Map<String, String>, EP> edgeParser) {
        return new DOTGraphParser<NP, EP, G>(creator, nodeParser, edgeParser);
    }
}

