/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.automatalib.commons.util.mappings.MapMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;

public interface IndefiniteSimpleGraph<N> {
    default public Iterable<N> adjacentTargets(N node) {
        return () -> this.adjacentTargetsIterator(node);
    }

    default public Iterator<N> adjacentTargetsIterator(N node) {
        return this.getAdjacentTargets(node).iterator();
    }

    public Collection<N> getAdjacentTargets(N var1);

    default public boolean isConnected(N source, N target) {
        return this.adjacentTargetsStream(source).anyMatch(n -> Objects.equals(n, target));
    }

    default public Stream<N> adjacentTargetsStream(N node) {
        return this.getAdjacentTargets(node).stream();
    }

    default public <V> MutableMapping<N, V> createStaticNodeMapping() {
        return new MapMapping();
    }

    default public <V> MutableMapping<N, V> createDynamicNodeMapping() {
        return new MapMapping();
    }

    default public IndefiniteGraph<N, ?> asNormalGraph() {
        return new NormalGraphView(this);
    }

    public static class NormalGraphView<N, G extends IndefiniteSimpleGraph<N>>
    implements IndefiniteGraph<N, N> {
        protected final G simpleGraph;

        public NormalGraphView(G simpleGraph) {
            this.simpleGraph = simpleGraph;
        }

        @Override
        public Iterator<N> adjacentTargetsIterator(N node) {
            return this.simpleGraph.adjacentTargetsIterator(node);
        }

        @Override
        public Collection<N> getAdjacentTargets(N node) {
            return this.simpleGraph.getAdjacentTargets(node);
        }

        @Override
        public Stream<N> adjacentTargetsStream(N node) {
            return this.simpleGraph.adjacentTargetsStream(node);
        }

        @Override
        public Collection<N> getOutgoingEdges(N node) {
            return this.simpleGraph.getAdjacentTargets(node);
        }

        @Override
        public N getTarget(N edge) {
            return edge;
        }

        @Override
        public Iterable<N> adjacentTargets(N node) {
            return this.simpleGraph.adjacentTargets(node);
        }

        @Override
        public boolean isConnected(N source, N target) {
            return this.simpleGraph.isConnected(source, target);
        }

        @Override
        public <V> MutableMapping<N, V> createStaticNodeMapping() {
            return this.simpleGraph.createStaticNodeMapping();
        }

        @Override
        public <V> MutableMapping<N, V> createDynamicNodeMapping() {
            return this.simpleGraph.createDynamicNodeMapping();
        }
    }
}

