/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.helpers;

import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.mappings.MutableMapping;

public class StateIDStaticMapping<S, V>
implements MutableMapping<S, V> {
    private final StateIDs<S> stateIds;
    private final V[] storage;

    public StateIDStaticMapping(StateIDs<S> stateIds, int size) {
        this.stateIds = stateIds;
        this.storage = new Object[size];
    }

    @Override
    public V get(S elem) {
        return this.storage[this.stateIds.getStateId(elem)];
    }

    @Override
    public V put(S key, V value) {
        V old = this.storage[this.stateIds.getStateId(key)];
        this.storage[this.stateIds.getStateId(key)] = value;
        return old;
    }
}

