/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.ResourceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DockTitleRequest
extends ResourceRequest<DockTitle> {
    private Dockable target;
    private DockStation parent;
    private DockTitleVersion version;
    private boolean installed = false;

    public DockTitleRequest(DockStation parent, Dockable target, DockTitleVersion version) {
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.target = target;
        this.parent = parent;
        this.version = version;
    }

    @Override
    public void request() {
        super.request();
    }

    public void install() {
        if (!this.installed) {
            this.installed = true;
            this.version.install(this);
        }
    }

    public void uninstall() {
        if (this.installed) {
            this.installed = false;
            this.version.uninstall(this);
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public Dockable getTarget() {
        return this.target;
    }

    public DockStation getParent() {
        return this.parent;
    }

    public DockTitleVersion getVersion() {
        return this.version;
    }

    @Override
    protected void executeRequestList() {
        this.requestDockTitle(this);
        if (this.isAnswered()) {
            return;
        }
        this.target.requestDockTitle(this);
        if (this.isAnswered()) {
            return;
        }
        if (this.parent != null) {
            this.parent.requestChildDockTitle(this);
            if (this.isAnswered()) {
                return;
            }
        }
        this.version.request(this);
    }

    public void requestDockTitle(DockTitleRequest request) {
    }

    @Override
    public void answer(DockTitle title) {
        super.answer(title);
    }

    @Override
    protected void validate(DockTitle resource) {
        if (resource != null) {
            if (resource.getDockable() != this.getTarget()) {
                throw new IllegalArgumentException("title.getDockable() does not return target");
            }
            if (resource.getOrigin() != this.getVersion()) {
                throw new IllegalArgumentException("title.getOrigin() does not return version");
            }
        }
    }
}

