/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.ScreenWindowShape;
import bibliothek.gui.dock.station.screen.window.ScreenWindowShapeCallback;
import bibliothek.util.Workarounds;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class ScreenWindowShapeAdapter {
    private ScreenDockWindow screenDockWindow;
    private Window window;
    private ScreenWindowShape shape;
    private boolean enabled = true;
    private Callback callback = new Callback();

    public ScreenWindowShapeAdapter(ScreenDockWindow screenDockWindow, Window window) {
        if (screenDockWindow == null) {
            throw new IllegalArgumentException("screenDockWindow must not be null");
        }
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        this.screenDockWindow = screenDockWindow;
        this.window = window;
    }

    public ScreenDockWindow getScreenDockWindow() {
        return this.screenDockWindow;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
        this.setShape((ScreenWindowShape)null);
    }

    public void setShape(ScreenWindowShape shape) {
        if ((this.isEnabled() || shape == null) && shape != this.shape) {
            if (this.shape != null) {
                this.shape.setCallback(null);
                this.window.removeComponentListener(this.callback);
            }
            this.shape = shape;
            if (this.shape != null) {
                this.shape.setCallback(this.callback);
                this.shape.onShown();
                this.window.addComponentListener(this.callback);
            }
        }
    }

    protected void setShape(Shape shape) {
        if (!Workarounds.getDefault().setTransparent(this.getWindow(), shape)) {
            this.disable();
        }
    }

    private class Callback
    extends ComponentAdapter
    implements ScreenWindowShapeCallback {
        private Callback() {
        }

        public ScreenDockWindow getWindow() {
            return ScreenWindowShapeAdapter.this.screenDockWindow;
        }

        public void setShape(Shape shape) {
            ScreenWindowShapeAdapter.this.setShape(shape);
        }

        public void componentResized(ComponentEvent e) {
            if (ScreenWindowShapeAdapter.this.shape != null) {
                ScreenWindowShapeAdapter.this.shape.onResize();
            }
        }

        public void componentShown(ComponentEvent e) {
            if (ScreenWindowShapeAdapter.this.shape != null) {
                ScreenWindowShapeAdapter.this.shape.onShown();
            }
        }
    }
}

