/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.DockStationDelegate;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import java.io.IOException;

public abstract class AbstractDockStation
implements DockStation {
    private DockController controller;
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;
    private DockComponentRootHandler rootHandler;

    protected DockComponentRootHandler getRootHandler() {
        if (this.rootHandler == null) {
            this.rootHandler = this.createRootHandler();
        }
        return this.rootHandler;
    }

    protected abstract DockComponentRootHandler createRootHandler();

    public void setController(DockController controller) {
        this.controller = controller;
        this.getRootHandler().setController(controller);
    }

    public DockController getController() {
        return this.controller;
    }

    public DockComponentConfiguration getComponentConfiguration() {
        return this.getRootHandler().getConfiguration();
    }

    public void setComponentConfiguration(DockComponentConfiguration configuration) {
        this.getRootHandler().setConfiguration(configuration);
    }

    public DockTheme getTheme() {
        return this.theme;
    }

    public void updateTheme() {
        DockTheme newTheme;
        DockController controller = this.getController();
        if (controller != null && (newTheme = controller.getTheme()) != this.theme) {
            this.theme = newTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    public void addDockStationListener(DockStationListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeDockStationListener(DockStationListener listener) {
        this.listeners.removeListener(listener);
    }

    public boolean isVisible(Dockable dockable) {
        return true;
    }

    public boolean accept(Dockable child) {
        return true;
    }

    public boolean canCompare(DockStation station) {
        return false;
    }

    public int compare(DockStation station) {
        return 0;
    }

    public void changed(Dockable dockable, DockTitle title, boolean active) {
        title.changed(new ActivityDockTitleEvent(this, dockable, active));
    }

    public void requestChildDockTitle(DockTitleRequest request) {
    }

    public void requestChildDisplayer(DisplayerRequest request) {
    }

    protected DockStationDelegate delegate() {
        return new DockStationDelegate();
    }
}

