/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.focus.DockableSelectionListener;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class DockableSelector {
    public static final PropertyKey<KeyStroke> INIT_SELECTION = new PropertyKey("dockable selector init selection keystroke");
    private PropertyValue<KeyStroke> initSelection = new PropertyValue<KeyStroke>(INIT_SELECTION){

        @Override
        protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
        }
    };
    private Listener listener = new Listener();
    private DockController controller;
    private DockableSelection selection;
    private JDialog dialog;

    public void setController(DockController controller) {
        this.cancel();
        if (this.controller != null) {
            this.controller.getKeyboardController().removeGlobalListener(this.listener);
        }
        this.controller = controller;
        this.initSelection.setProperties(controller);
        if (this.controller != null) {
            this.controller.getKeyboardController().addGlobalListener(this.listener);
        }
    }

    public void select() {
        if (!this.isOpen()) {
            this.cancel();
            this.open();
        }
    }

    public boolean isOpen() {
        return this.selection != null && this.dialog != null && this.dialog.isVisible();
    }

    public void cancel() {
        this.close();
    }

    public void stop(Dockable dockable) {
        this.close();
        this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, null, false));
    }

    private void open() {
        this.selection = this.controller.getProperties().get(DockTheme.DOCKABLE_SELECTION);
        if (this.selection != null && this.selection.hasChoices(this.controller)) {
            Window root = this.controller.findRootWindow();
            if (this.dialog == null || this.dialog.getOwner() != root) {
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                if (root instanceof Frame) {
                    this.dialog = new JDialog((Frame)root, false);
                } else if (root instanceof Dialog) {
                    this.dialog = new JDialog((Dialog)root, false);
                } else {
                    this.dialog = new JDialog();
                    this.dialog.setModal(false);
                }
                this.dialog.setDefaultCloseOperation(0);
                this.dialog.setUndecorated(true);
                this.dialog.getRootPane().setWindowDecorationStyle(0);
                this.dialog.setLayout(new BorderLayout());
            }
            this.dialog.addWindowFocusListener(this.listener);
            this.selection.open(this.controller);
            Component base = this.selection.getComponent();
            this.dialog.add(base, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(root);
            this.selection.addDockableSelectionListener(this.listener);
            base.requestFocusInWindow();
            this.dialog.setVisible(true);
        } else {
            this.selection = null;
        }
    }

    private void close() {
        if (this.dialog != null) {
            if (this.selection != null) {
                this.dialog.removeWindowFocusListener(this.listener);
                this.selection.removeDockableSelectionListener(this.listener);
                this.selection.close();
                this.selection = null;
            }
            this.dialog.setVisible(false);
            this.dialog.getContentPane().removeAll();
        }
    }

    private class Listener
    implements KeyListener,
    DockableSelectionListener,
    WindowFocusListener {
        private Listener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.isConsumed()) {
                return;
            }
            if (KeyStroke.getKeyStrokeForEvent(event).equals(DockableSelector.this.initSelection.getValue())) {
                DockableSelector.this.select();
                event.consume();
            }
        }

        public void keyReleased(KeyEvent event) {
            if (event.isConsumed()) {
                return;
            }
            if (KeyStroke.getKeyStrokeForEvent(event).equals(DockableSelector.this.initSelection.getValue())) {
                DockableSelector.this.select();
                event.consume();
            }
        }

        public void keyTyped(KeyEvent event) {
            if (event.isConsumed()) {
                return;
            }
            if (KeyStroke.getKeyStrokeForEvent(event).equals(DockableSelector.this.initSelection.getValue())) {
                DockableSelector.this.select();
                event.consume();
            }
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
            if (DockableSelector.this.selection != null) {
                DockableSelector.this.cancel();
            }
        }

        public void canceled() {
            DockableSelector.this.cancel();
        }

        public void considering(Dockable dockable) {
        }

        public void selected(Dockable dockable) {
            DockableSelector.this.stop(dockable);
        }
    }
}

