/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;

public class DefaultGlobalMouseDispatcher
implements GlobalMouseDispatcher {
    private AWTEventListener listener;
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private MouseListener[] mouseListenersCache = null;
    private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
    private MouseMotionListener[] mouseMotionListenersCache = null;
    private List<MouseWheelListener> mouseWheelListeners = new ArrayList<MouseWheelListener>();
    private MouseWheelListener[] mouseWheelListenersCache = null;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            DefaultGlobalMouseDispatcher.this.updateRestricted();
        }
    };

    public DefaultGlobalMouseDispatcher(DockController controller, ControllerSetupCollection setup) {
        setup.add(new ControllerSetupListener(){

            public void done(DockController controller) {
                DefaultGlobalMouseDispatcher.this.restricted.setProperties(controller);
                DefaultGlobalMouseDispatcher.this.updateRestricted();
            }
        });
    }

    public void dispatch(MouseEvent event) {
        switch (event.getID()) {
            case 500: {
                for (MouseListener listener : this.getMouseListeners()) {
                    listener.mouseClicked(event);
                }
                break;
            }
            case 506: {
                for (MouseMotionListener listener : this.getMouseMotionListeners()) {
                    listener.mouseDragged(event);
                }
                break;
            }
            case 504: {
                for (MouseListener listener : this.getMouseListeners()) {
                    listener.mouseEntered(event);
                }
                break;
            }
            case 505: {
                for (MouseListener listener : this.getMouseListeners()) {
                    listener.mouseExited(event);
                }
                break;
            }
            case 503: {
                for (MouseMotionListener listener : this.getMouseMotionListeners()) {
                    listener.mouseMoved(event);
                }
                break;
            }
            case 501: {
                for (MouseListener listener : this.getMouseListeners()) {
                    listener.mousePressed(event);
                }
                break;
            }
            case 502: {
                for (MouseListener listener : this.getMouseListeners()) {
                    listener.mouseReleased(event);
                }
                break;
            }
            case 507: {
                for (MouseWheelListener listener : this.getMouseWheelListeners()) {
                    listener.mouseWheelMoved((MouseWheelEvent)event);
                }
                break;
            }
            default: {
                throw new IllegalStateException("unknown type of MouseEvent: " + event);
            }
        }
    }

    public synchronized void addMouseListener(MouseListener listener) {
        this.mouseListeners.add(listener);
        this.mouseListenersCache = null;
    }

    public synchronized void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
        this.mouseListenersCache = null;
    }

    protected synchronized MouseListener[] getMouseListeners() {
        if (this.mouseListenersCache == null) {
            this.mouseListenersCache = this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]);
        }
        return this.mouseListenersCache;
    }

    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListeners.add(listener);
        this.mouseMotionListenersCache = null;
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListeners.remove(listener);
        this.mouseMotionListenersCache = null;
    }

    protected synchronized MouseMotionListener[] getMouseMotionListeners() {
        if (this.mouseMotionListenersCache == null) {
            this.mouseMotionListenersCache = this.mouseMotionListeners.toArray(new MouseMotionListener[this.mouseMotionListeners.size()]);
        }
        return this.mouseMotionListenersCache;
    }

    public synchronized void addMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListeners.add(listener);
        this.mouseWheelListenersCache = null;
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListeners.remove(listener);
        this.mouseWheelListenersCache = null;
    }

    protected synchronized MouseWheelListener[] getMouseWheelListeners() {
        if (this.mouseWheelListenersCache == null) {
            this.mouseWheelListenersCache = this.mouseWheelListeners.toArray(new MouseWheelListener[this.mouseWheelListeners.size()]);
        }
        return this.mouseWheelListenersCache;
    }

    private void updateRestricted() {
        if (this.restricted.getProperties() != null) {
            if (!this.restricted.getValue().booleanValue()) {
                if (this.listener == null) {
                    this.listener = this.createListener();
                    try {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 131120L);
                    }
                    catch (SecurityException ex) {
                        System.err.println("Can't register AWTEventListener, support for global MouseEvents disabled");
                        ex.printStackTrace();
                    }
                }
            } else if (this.listener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
                this.listener = null;
            }
        }
    }

    public void kill() {
        if (this.listener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
            this.listener = null;
        }
        this.restricted.setProperties((DockController)null);
    }

    protected AWTEventListener createListener() {
        return new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    DefaultGlobalMouseDispatcher.this.dispatch((MouseEvent)event);
                }
            }
        };
    }
}

