/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ActionBinder
extends DockRegisterAdapter {
    private Map<Dockable, SourceObserver> observers = new HashMap<Dockable, SourceObserver>();
    private DockController controller;

    public ActionBinder(DockController controller) {
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public void dockableRegistered(DockController controller, Dockable dockable) {
        this.observers.put(dockable, new SourceObserver(dockable));
    }

    public void dockableUnregistered(DockController controller, Dockable dockable) {
        this.observers.remove(dockable).destroy();
    }

    private static class SourceObserver
    implements DockActionSourceListener {
        private List<DockAction> actions = new LinkedList<DockAction>();
        private Dockable dockable;

        public SourceObserver(Dockable dockable) {
            this.dockable = dockable;
            DockActionSource source = dockable.getGlobalActionOffers();
            this.actionsAdded(source, 0, source.getDockActionCount() - 1);
            source.addDockActionSourceListener(this);
        }

        public void destroy() {
            DockActionSource source = this.dockable.getGlobalActionOffers();
            source.removeDockActionSourceListener(this);
            this.actionsRemoved(source, 0, source.getDockActionCount() - 1);
        }

        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                DockAction action = source.getDockAction(i);
                this.actions.add(i, action);
                action.bind(this.dockable);
            }
        }

        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            for (int i = lastIndex; i >= firstIndex; --i) {
                DockAction action = this.actions.remove(i);
                action.unbind(this.dockable);
            }
        }
    }
}

