/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.io.SNSFileFilter;
import de.renew.shadow.ShadowNetSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import javax.swing.filechooser.FileFilter;

public class SNSExportFormat
extends ExportFormatAbstract {
    public SNSExportFormat() {
        super("ShadowNetSystem", (FileFilter)((Object)new SNSFileFilter()));
    }

    public boolean canExportNto1() {
        return true;
    }

    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);
            ObjectOutputStream output = new ObjectOutputStream(stream);
            ShadowNetSystem netSystem = new ShadowNetSystem(ModeReplacement.getInstance().getDefaultCompilerFactory());
            CPNDrawing cpndrawing = (CPNDrawing)drawing;
            cpndrawing.buildShadow(netSystem);
            output.writeObject(netSystem);
            output.close();
        }
        assert (result != null) : "Failure in SNSExportFormat: result == null";
        return result;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        if (drawings != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);
            ObjectOutputStream output = new ObjectOutputStream(stream);
            ShadowNetSystem system = new ShadowNetSystem(ModeReplacement.getInstance().getDefaultCompilerFactory());
            for (Drawing value : drawings) {
                CPNDrawing drawing = (CPNDrawing)value;
                drawing.buildShadow(system);
            }
            output.writeObject(system);
            output.close();
        }
        assert (result != null) : "Failure in SNSExportFormat: result == null";
        return result;
    }

    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}

