/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.NodeParser;
import de.renew.plugin.PluginManager;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransitionParser
extends NodeParser {
    private static final Logger logger = Logger.getLogger(TransitionParser.class);
    private String subtypeClass = null;

    public TransitionParser(Element node, NetConverter converter) {
        super(node, converter);
        NodeList toolspecificEles = node.getElementsByTagName("toolspecific");
        for (int i = 0; i < toolspecificEles.getLength(); ++i) {
            NodeList subtypeEles = ((Element)toolspecificEles.item(i)).getElementsByTagName("subtype");
            int length = subtypeEles.getLength();
            if (length <= 0) continue;
            if (length > 1) {
                logger.warn((Object)(TransitionParser.class.getSimpleName() + ": more than one subtype element."));
            }
            Element subtype = (Element)subtypeEles.item(0);
            this.subtypeClass = subtype.getAttribute("class");
            return;
        }
    }

    @Override
    public FigureWithID createObject() {
        if (this.subtypeClass != null) {
            try {
                return (FigureWithID)Class.forName(this.subtypeClass, true, PluginManager.getInstance().getBottomClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error((Object)(TransitionParser.class.getSimpleName() + ": " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return new TransitionFigure();
    }
}

