/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.PlaceInstanceFigure;
import de.renew.gui.TokenBagFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.TransitionInstanceFigure;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import java.util.ArrayList;

public class ToggleBreakpointCommand
extends UndoableCommand {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int GLOBAL = 10;
    public static final int LOCAL = 11;
    public static final int PRESET = 12;
    private final BreakpointManager manager;
    private final int op;
    private final int context;
    private final int breakpointMode;

    public ToggleBreakpointCommand(String name, BreakpointManager manager, int op, int context) {
        this(name, manager, op, context, 0);
    }

    public ToggleBreakpointCommand(String name, BreakpointManager manager, int op, int context, int mode) {
        super(name);
        this.manager = manager;
        this.op = op;
        this.context = context;
        this.breakpointMode = mode;
    }

    public boolean isExecutable() {
        CPNInstanceDrawing cpnInstanceDrawing;
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        DrawingView view = this.getEditor().view();
        if (view.selectionCount() <= 0) {
            return false;
        }
        if (view.selectionCount() > 1) {
            CPNInstanceDrawing cpnInstanceDrawing2;
            if (this.context == 12) {
                return drawing instanceof CPNDrawing;
            }
            return drawing instanceof CPNInstanceDrawing && (cpnInstanceDrawing2 = (CPNInstanceDrawing)drawing).isLocal();
        }
        Figure figure = (Figure)view.selectionElements().nextElement();
        if (this.context == 12) {
            if (figure instanceof TransitionFigure) {
                return BreakpointManager.isValidTransitionMode(this.breakpointMode);
            }
            if (figure instanceof PlaceFigure) {
                return BreakpointManager.isValidPlaceMode(this.breakpointMode);
            }
        } else if (drawing instanceof CPNInstanceDrawing && (cpnInstanceDrawing = (CPNInstanceDrawing)drawing).isLocal()) {
            if (figure instanceof TransitionInstanceFigure) {
                return BreakpointManager.isValidTransitionMode(this.breakpointMode);
            }
            if (figure instanceof PlaceInstanceFigure || figure instanceof TokenBagFigure) {
                return BreakpointManager.isValidPlaceMode(this.breakpointMode);
            }
        }
        return false;
    }

    public boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        int count = 0;
        ArrayList<PlaceInstanceAccessor> memory = new ArrayList<PlaceInstanceAccessor>();
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            FigureEnumeration figures = view.selectionElements();
            while (figures.hasMoreElements()) {
                Breakpoint bp;
                Net net;
                Figure figure = figures.nextFigure();
                if (this.context == 12) {
                    if (figure instanceof TransitionFigure) {
                        switch (this.op) {
                            case 1: {
                                if (!BreakpointManager.isValidTransitionMode(this.breakpointMode)) break;
                                figure.setAttribute("BreakpointMode", (Object)this.breakpointMode);
                                ++count;
                                break;
                            }
                            case 2: {
                                if (figure.getAttribute("BreakpointMode") == null) break;
                                figure.setAttribute("BreakpointMode", null);
                                ++count;
                            }
                        }
                        continue;
                    }
                    if (!(figure instanceof PlaceFigure)) continue;
                    switch (this.op) {
                        case 1: {
                            if (!BreakpointManager.isValidPlaceMode(this.breakpointMode)) break;
                            figure.setAttribute("BreakpointMode", (Object)this.breakpointMode);
                            ++count;
                            break;
                        }
                        case 2: {
                            if (figure.getAttribute("BreakpointMode") == null) break;
                            figure.setAttribute("BreakpointMode", null);
                            ++count;
                        }
                    }
                    continue;
                }
                if (figure instanceof TransitionInstanceFigure) {
                    TransitionInstanceAccessor transitionInstAccessor = ((TransitionInstanceFigure)figure).getInstance();
                    if (!(transitionInstAccessor instanceof TransitionInstanceAccessorImpl)) {
                        throw new IllegalStateException("Only the local simulation may set breakpoints");
                    }
                    TransitionInstance transitionInst = ((TransitionInstanceAccessorImpl)transitionInstAccessor).getTransitionInstance();
                    Transition transition = transitionInst.getTransition();
                    net = transitionInst.getNetInstance().getNet();
                    switch (this.op) {
                        case 1: {
                            bp = this.context == 10 ? this.manager.createTransitionBreakpoint(transition, this.breakpointMode, net) : this.manager.createTransitionInstanceBreakpoint(transitionInst, this.breakpointMode);
                            if (bp == null) break;
                            ++count;
                            break;
                        }
                        case 2: {
                            if (this.context == 10) {
                                count += this.manager.deleteBreakpointsAt(transition);
                                break;
                            }
                            count += this.manager.deleteBreakpointsAt(transitionInst);
                        }
                    }
                    continue;
                }
                PlaceInstanceAccessor placeInstAccessor = null;
                if (figure instanceof PlaceInstanceFigure) {
                    placeInstAccessor = ((PlaceInstanceFigure)figure).getInstance();
                } else if (figure instanceof TokenBagFigure) {
                    placeInstAccessor = ((TokenBagFigure)figure).getPlaceInstance();
                }
                if (memory.contains(placeInstAccessor)) {
                    placeInstAccessor = null;
                }
                if (placeInstAccessor == null) continue;
                if (!(placeInstAccessor instanceof PlaceInstanceAccessorImpl)) {
                    throw new IllegalStateException("Only the local simulation may set breakpoints");
                }
                PlaceInstance placeInst = ((PlaceInstanceAccessorImpl)placeInstAccessor).getPlaceInstance();
                memory.add(placeInstAccessor);
                Place place = placeInst.getPlace();
                net = placeInst.getNetInstance().getNet();
                switch (this.op) {
                    case 1: {
                        bp = this.context == 10 ? this.manager.createPlaceBreakpoint(place, this.breakpointMode, net) : this.manager.createPlaceInstanceBreakpoint(placeInst, this.breakpointMode);
                        if (bp == null) break;
                        ++count;
                        break;
                    }
                    case 2: {
                        if (this.context == 10) {
                            count += this.manager.deleteBreakpointsAt(place);
                            break;
                        }
                        count += this.manager.deleteBreakpointsAt(placeInst);
                    }
                }
            }
            view.checkDamage();
            StringBuilder message = new StringBuilder();
            if (count == 1) {
                message.append("1 breakpoint");
            } else {
                message.append(count).append(" breakpoints");
            }
            switch (this.op) {
                case 1: {
                    message.append(" set.");
                    break;
                }
                case 2: {
                    message.append(" cleared.");
                }
            }
            this.getEditor().showStatus(message.toString());
            return this.context == 12 && count > 0;
        }
        return false;
    }
}

