/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorPlugin;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.awt.EventQueue;
import org.apache.log4j.Logger;

public class NetInstanceBuilder {
    private static final Logger logger = Logger.getLogger(NetInstanceBuilder.class);

    public static void buildInstanceFromDrawing(CPNDrawing cpnd) {
        NetInstanceBuilder.buildInstanceFromDrawing(cpnd, FormalismPlugin.getCurrent().getCompiler());
    }

    public static void buildInstanceFromDrawing(CPNDrawing cpnd, String formalismName) {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        NetInstanceBuilder.buildInstanceFromDrawing(cpnd, fp.getCompilerFactoryByName(formalismName));
    }

    public static void buildInstanceFromDrawing(CPNDrawing cpnd, ShadowCompilerFactory compilerFactory) {
        if (!cpnd.getName().equals("untitled")) {
            ShadowNetSystem sns = new ShadowNetSystem(compilerFactory);
            cpnd.buildShadow(sns);
            SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
            try {
                simulatorPlugin.insertNets(sns);
            }
            catch (NoSimulationException e) {
                logger.error((Object)"Simulation was terminated befor the new net has been initialized");
            }
            catch (SyntaxException e) {
                EventQueue.invokeLater(() -> GuiPlugin.getCurrent().processSyntaxException(FigureExceptionFactory.createFigureException(e), true));
            }
        }
    }
}

