/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.FigureException;
import de.renew.gui.CPNDrawing;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.SyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureExceptionFactory {
    private static final Logger logger = Logger.getLogger(FigureExceptionFactory.class);

    public static FigureException createFigureException(SyntaxException e, Drawing errorDrawing, TextFigure textErrorFigure) {
        int line = e.line;
        int column = e.column;
        String message = e.getMessage();
        Object o = e.getProblemSpecificInformation();
        logger.debug((Object)"Syntax Error: ", (Throwable)e);
        return new FigureException(message, line, column, errorDrawing, textErrorFigure, o);
    }

    public static FigureException createFigureException(SyntaxException e) {
        CPNDrawing errorDrawing;
        int line = e.line;
        int column = e.column;
        String message = e.getMessage();
        Object o = e.getProblemSpecificInformation();
        TextFigure textErrorFigure = null;
        Vector<Figure> errorFigures = new Vector<Figure>();
        if (!e.errorObjects.isEmpty()) {
            errorDrawing = CPNDrawing.findDrawing(e.errorObjects.elementAt(0));
            if (errorDrawing != null) {
                boolean errorFound = false;
                Enumeration errorObjects = e.errorObjects.elements();
                while (errorObjects.hasMoreElements()) {
                    Object errorObject = errorObjects.nextElement();
                    Figure errorFigure = null;
                    if (errorObject instanceof ShadowNetElement) {
                        errorFigure = (Figure)((ShadowNetElement)errorObject).context;
                    }
                    if (errorFigure == null) continue;
                    if (errorFound) {
                        textErrorFigure = null;
                    } else {
                        TextFigure textFigure;
                        errorFound = true;
                        if (e.line > 0 && e.column > 0 && errorFigure instanceof TextFigure && (textFigure = (TextFigure)errorFigure).acceptsTyping()) {
                            textErrorFigure = textFigure;
                        }
                    }
                    errorFigures.addElement(errorFigure);
                }
            }
        } else {
            errorDrawing = null;
        }
        logger.debug((Object)"Syntax Error: ", (Throwable)e);
        return new FigureException(message, line, column, (Drawing)errorDrawing, textErrorFigure, errorFigures, o);
    }
}

