/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.RelativeLocator;
import de.renew.gui.ArcConnection;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ArcConnectionHandle
extends ConnectionHandle {
    public ArcConnectionHandle(Figure owner) {
        super(owner, RelativeLocator.center(), (ConnectionFigure)ArcConnection.NormalArc);
    }

    protected PlaceFigure createPlaceFigure() {
        PlaceFigure figure = new PlaceFigure();
        Dimension d = PlaceFigure.defaultDimension();
        figure.displayBox(new Point(0, 0), new Point(d.width, d.height));
        return figure;
    }

    protected TransitionFigure createTransitionFigure() {
        TransitionFigure figure = new TransitionFigure();
        Dimension d = TransitionFigure.defaultDimension();
        figure.displayBox(new Point(0, 0), new Point(d.width, d.height));
        return figure;
    }

    protected void addInscriptions(Figure figure, DrawingView view) {
    }

    public void invokeEnd(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target == null) {
            Figure owner = this.owner();
            if (e.isControlDown()) {
                Point snap = this.snap(x, y);
                x = snap.x;
                y = snap.y;
            }
            if (owner.findFigureInside(x, y) == null) {
                FigureWithHighlight endFigure = owner instanceof PlaceFigure ? this.createTransitionFigure() : this.createPlaceFigure();
                Rectangle rect = endFigure.displayBox();
                int w2 = rect.width / 2;
                int h2 = rect.height / 2;
                endFigure.displayBox(new Point(x - w2, y - h2), new Point(x - w2 + rect.width, y - h2 + rect.height));
                view.add((Figure)endFigure);
                this.addInscriptions((Figure)endFigure, view);
            }
        }
        super.invokeEnd(x, y, anchorX, anchorY, view);
    }

    protected Point snap(int x, int y) {
        Point ownerCenter = this.owner().center();
        Point targetPoint = new Point(x, y);
        Point arcVector = new Point(targetPoint.x - ownerCenter.x, targetPoint.y - ownerCenter.y);
        double r = arcVector.distance(0.0, 0.0);
        double theta = Math.atan2(arcVector.y, arcVector.x);
        theta = (theta + Math.PI * 2) % (Math.PI * 2);
        int segmentCount = 8;
        double segmentSize = Math.PI * 2 / (double)segmentCount;
        double newTheta = (theta + segmentSize / 2.0) % (Math.PI * 2);
        newTheta -= newTheta % segmentSize;
        int snapX = (int)((double)ownerCenter.x + r * Math.cos(newTheta));
        int snapY = (int)((double)ownerCenter.y + r * Math.sin(newTheta));
        return new Point(snapX, snapY);
    }
}

