/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.PDFFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.export.io.exportFormats.ExportPlugin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PDFExportFormat
extends ExportFormatAbstract {
    public static final Logger LOGGER = Logger.getLogger(PDFExportFormat.class);

    public PDFExportFormat() {
        super("PDF", (FileFilter)new PDFFileFilter());
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in PDFExportFormat: result == null";
        return result;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle bounds = drawing.getBounds();
        return this.internalExport(drawing, file, bounds);
    }

    public File internalExport(Drawing drawing, File path, Rectangle bounds) throws Exception {
        File result = null;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        Dimension d = new Dimension(width, height);
        PDFGraphics2D graphics = new PDFGraphics2D(path, d);
        String pageSize = "BoundingBox";
        String pageOrientation = "Portrait";
        ExportPlugin plugin = ExportPlugin.getCurrent();
        if (plugin != null) {
            pageSize = plugin.getPageSize();
            pageOrientation = plugin.getPageOrientation();
        }
        UserProperties defaultProperties = new UserProperties();
        if (pageSize.equals("BoundingBox")) {
            defaultProperties.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
            defaultProperties.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, d);
            defaultProperties.setProperty(PDFGraphics2D.PAGE_MARGINS, new Insets(0, 0, 0, 0));
        } else {
            defaultProperties.setProperty(PDFGraphics2D.PAGE_SIZE, pageSize);
            defaultProperties.setProperty(PDFGraphics2D.ORIENTATION, pageOrientation);
        }
        graphics.setProperties((Properties)defaultProperties);
        graphics.startExport();
        graphics.translate(-x, -y);
        graphics.clipRect(x, y, width, height);
        drawing.draw((Graphics)graphics);
        graphics.endExport();
        result = path;
        assert (result != null) : "Failure in PDFExportFormat: result == null";
        return result;
    }

    public boolean canExportDrawing(Drawing drawing) {
        return true;
    }

    public int getModifier() {
        return 64 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    }

    public int getShortCut() {
        return 80;
    }
}

