/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.facile.menu.NodeMenuPiece;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JMenu;

public class RootMenuPiece
extends NodeMenuPiece {
    private JMenu menu;
    private boolean disableWhenEmpty;
    private boolean enabled = true;

    public RootMenuPiece() {
        this(new JMenu());
    }

    public RootMenuPiece(String text, boolean disableWhenEmpty, MenuPiece ... pieces) {
        this(new JMenu(text));
        this.setDisableWhenEmpty(disableWhenEmpty);
        for (MenuPiece piece : pieces) {
            this.add(piece);
        }
    }

    public RootMenuPiece(JMenu menu) {
        if (menu == null) {
            throw new NullPointerException("menu must not be null");
        }
        this.menu = menu;
        menu.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            RootMenuPiece.this.checkVisibility();
                        }
                    });
                }
            }
        });
        this.checkVisibility();
        this.addListener(new MenuPieceListener(){

            public void insert(MenuPiece child, int index, Component ... items) {
                JMenu menu = RootMenuPiece.this.getMenu();
                for (int i = 0; i < items.length; ++i) {
                    menu.add(items[i], i + index);
                }
                RootMenuPiece.this.updateEnabled();
            }

            public void remove(MenuPiece child, int index, int length) {
                JMenu menu = RootMenuPiece.this.getMenu();
                for (int i = index + length - 1; i >= index; --i) {
                    menu.remove(i);
                }
                RootMenuPiece.this.updateEnabled();
            }
        });
    }

    protected void updateEnabled() {
        if (this.isEnabled()) {
            if (this.isDisableWhenEmpty()) {
                this.menu.setEnabled(this.getItemCount() > 0);
            } else {
                this.menu.setEnabled(true);
            }
        } else {
            this.menu.setEnabled(false);
        }
    }

    private void checkVisibility() {
        boolean showing = this.getParent() == null ? this.menu.isShowing() : this.getParent().isBound();
        if (showing && !this.isBound()) {
            this.bind();
        } else if (!showing && this.isBound()) {
            this.unbind();
        }
    }

    public void setDisableWhenEmpty(boolean disableWhenEmpty) {
        this.disableWhenEmpty = disableWhenEmpty;
        this.updateEnabled();
    }

    public boolean isDisableWhenEmpty() {
        return this.disableWhenEmpty;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setParent(MenuPiece parent) {
        super.setParent(parent);
        this.checkVisibility();
    }
}

