/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.propertymanagement;

import de.renew.plugin.propertymanagement.ConfigurableProperty;
import de.renew.plugin.propertymanagement.ConfigurablePropertyPersister;
import de.renew.plugin.propertymanagement.PropertyChangeEvent;
import de.renew.plugin.propertymanagement.PropertyChangeListener;
import de.renew.plugin.propertymanagement.PropertyChangeType;
import de.renew.plugin.propertymanagement.PropertyLoadFailedException;
import de.renew.plugin.propertymanagement.PropertySaveFailedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.log4j.Logger;

public class ConfigurablePropertyManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigurablePropertyManager.class);
    private static ConfigurablePropertyManager _instance;
    private final ConfigurablePropertyPersister _persister;
    private final Map<String, ConfigurableProperty> _properties = new HashMap<String, ConfigurableProperty>();
    private final List<PropertyChangeListener> _listeners = new ArrayList<PropertyChangeListener>();

    private ConfigurablePropertyManager() {
        this._persister = new ConfigurablePropertyPersister();
    }

    public static ConfigurablePropertyManager getInstance() {
        if (_instance == null) {
            _instance = new ConfigurablePropertyManager();
        }
        return _instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._listeners.remove(listener);
    }

    public void addConfigurableProperty(String key, String defaultValue, String pluginName, String displayName, String[] selectionChoices) {
        ConfigurableProperty configurableProperty = new ConfigurableProperty(key, defaultValue, pluginName, displayName, selectionChoices);
        this._properties.put(key, configurableProperty);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, key, defaultValue);
        this.notifyListeners(propertyChangeEvent, PropertyChangeType.PROPERTY_ADDED);
    }

    public void removeConfigurableProperty(String key) {
        ConfigurableProperty oldValue = this._properties.get(key);
        if (oldValue == null) {
            LOGGER.warn((Object)"PropertyManager: Attempting to remove a property that was not added before.");
        } else {
            this._properties.remove(key);
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, key, oldValue.getCurrentValue(), null);
            this.notifyListeners(propertyChangeEvent, PropertyChangeType.PROPERTY_REMOVED);
        }
    }

    public void changeProperty(String key, String newValue) {
        PropertyChangeEvent propertyChangeEvent;
        if (this._properties.containsKey(key)) {
            ConfigurableProperty configurableProperty = this._properties.get(key);
            configurableProperty.setCurrentValue(newValue);
            propertyChangeEvent = new PropertyChangeEvent(this, key, configurableProperty.getCurrentValue(), newValue);
        } else {
            LOGGER.warn((Object)"PropertyManager: Changing a property that was not added before. Adding it now");
            propertyChangeEvent = new PropertyChangeEvent(this, key, newValue);
            ConfigurableProperty configurableProperty = new ConfigurableProperty(key, null);
            this._properties.put(key, configurableProperty);
            this.notifyListeners(propertyChangeEvent, PropertyChangeType.PROPERTY_ADDED);
        }
        this.notifyListeners(propertyChangeEvent, PropertyChangeType.PROPERTY_CHANGED);
    }

    public void saveProperties(boolean useHomeDir) throws PropertySaveFailedException {
        this._persister.saveProperties(useHomeDir, this._properties);
    }

    public void loadProperties(boolean useHomeDir) throws PropertyLoadFailedException {
        this._persister.loadProperties(useHomeDir, this._properties);
    }

    private void notifyListeners(PropertyChangeEvent event, PropertyChangeType notificationType) {
        switch (notificationType) {
            case PROPERTY_ADDED: {
                for (PropertyChangeListener listener : this._listeners) {
                    listener.propertyAdded(event);
                }
                break;
            }
            case PROPERTY_CHANGED: {
                for (PropertyChangeListener listener : this._listeners) {
                    listener.propertyChanged(event);
                }
                break;
            }
            case PROPERTY_REMOVED: {
                for (PropertyChangeListener listener : this._listeners) {
                    listener.propertyRemoved(event);
                }
                break;
            }
            default: {
                LOGGER.error((Object)"Tried to notify listeners for an unknown notification type.");
            }
        }
    }

    public Optional<String> getDisplayNameForProperty(String key) throws NoSuchElementException {
        return Optional.ofNullable(Optional.ofNullable(this._properties.get(key)).orElseThrow().getDisplayName());
    }

    public Optional<String> getPluginForProperty(String key) throws NoSuchElementException {
        return Optional.ofNullable(Optional.ofNullable(this._properties.get(key)).orElseThrow().getPluginName());
    }

    public Optional<String> getCurrentValueForProperty(String key) throws NoSuchElementException {
        return Optional.ofNullable(Optional.ofNullable(this._properties.get(key)).orElseThrow().getCurrentValue());
    }

    public Map<String, ConfigurableProperty> getConfigurableProperties() {
        return Collections.unmodifiableMap(this._properties);
    }
}

