/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.plugin.di.DependencyFinder;
import de.renew.plugin.di.MissingDependencyException;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.load.PluginInstantiationException;
import de.renew.plugin.load.SimplePluginLoader;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DIPluginLoader
extends SimplePluginLoader
implements DependencyFinder {
    public static final Logger LOGGER = Logger.getLogger(DIPluginLoader.class);

    public DIPluginLoader(PluginClassLoader loader, ServiceContainer container) {
        super(loader, container);
    }

    @Override
    public Object findDependency(Class<?> service) throws MissingDependencyException {
        return this._container.get(service);
    }

    @Override
    protected IPlugin createPlugin(PluginProperties props, Class<? extends IPlugin> mainClass) throws PluginInstantiationException {
        Class<?>[] params;
        Constructor<?> injectionPoint = this.findInjectionPoint(mainClass);
        if (injectionPoint == null) {
            try {
                IPlugin plugin = mainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (plugin instanceof DIPlugin) {
                    LOGGER.warn((Object)(props.getName() + " has no injection point."));
                    DIPlugin diPlugin = (DIPlugin)plugin;
                    diPlugin.setProperties(props);
                    return diPlugin;
                }
                return null;
            }
            catch (ReflectiveOperationException e) {
                throw new PluginInstantiationException(props.getName(), e);
            }
        }
        LinkedList<Object> dependencies = new LinkedList<Object>();
        for (Class<?> param : params = injectionPoint.getParameterTypes()) {
            try {
                dependencies.add(this.findDependency(param));
            }
            catch (MissingDependencyException e) {
                throw new PluginInstantiationException(props.getName(), e);
            }
        }
        try {
            Object plugin = injectionPoint.newInstance(dependencies.toArray());
            if (!(plugin instanceof DIPlugin)) {
                return null;
            }
            DIPlugin diPlugin = (DIPlugin)plugin;
            diPlugin.setProperties(props);
            return diPlugin;
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                LOGGER.error((Object)(props.getName() + " fails during instantiation!"));
                e.getCause().printStackTrace();
            }
            throw new PluginInstantiationException(props.getName(), e);
        }
    }

    private Constructor<?> findInjectionPoint(Class<? extends IPlugin> pluginClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = pluginClass.getConstructors()) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return constructor;
        }
        return null;
    }
}

