/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ApplicationTracker
implements IPluginManagerListener {
    public static final Logger LOGGER = Logger.getLogger(ApplicationTracker.class);
    protected String _requiredService;
    protected Collection<IPlugin> _applicationList;
    private PluginManager _mgr;

    public ApplicationTracker(String requiredService) {
        this._requiredService = requiredService;
        this._applicationList = new ArrayList<IPlugin>();
        this._mgr = PluginManager.getInstance();
    }

    public void open() {
        this._mgr.addPluginManagerListener(this);
        this.bindServices(this._mgr.getPluginsRequiring(this._requiredService));
    }

    public synchronized void close() {
        this._mgr.removePluginManagerListener(this);
        this.unbindServices(this._mgr.getPluginsRequiring(this._requiredService));
    }

    private void bindServices(Collection<IPlugin> applicationList) {
        if (applicationList != null) {
            for (IPlugin provider : applicationList) {
                this.bindService(provider);
            }
        }
    }

    private void unbindServices(Collection<IPlugin> applicationList) {
        for (IPlugin provider : applicationList) {
            this.unbindService(provider);
        }
        assert (this._applicationList.isEmpty()) : "There is a difference between the \nlist of plugins requiring " + this._requiredService + " of the plugin manager and the application service tracker (" + String.valueOf(this) + ").\n[Tracked required service: " + this._requiredService + "].\nRemaining plugins : " + String.valueOf(this._applicationList) + ".";
    }

    protected void bindService(IPlugin application) {
        if (application != null && application.getProperties().getRequirements().contains(this._requiredService)) {
            this._applicationList.add(application);
        }
    }

    protected void unbindService(IPlugin application) {
        if (application != null && this._applicationList.contains(application)) {
            this._applicationList.remove(application);
        }
    }

    @Override
    public synchronized void serviceAdded(String service, IPlugin application) {
        if (application != null) {
            this.bindService(application);
        }
    }

    @Override
    public synchronized void serviceRemoved(String service, IPlugin application) {
        if (application != null) {
            this.unbindService(application);
        }
    }
}

