/*
 * Decompiled with CFR 0.152.
 */
package de.renew.mxml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MXMLCommandCenter {
    public static final String PROCESS_SEP = "`";
    public static final String AUDIT_TRAIL_SEP = "\u00a7";
    public static final String PROCESS_INST_SEP = "\u00b5";
    public static final String DATA_SEP = "%";
    public static final String ATRIBUTE_SEP = "&";
    public static final int PROCESS = 1;
    public static final int PROCESS_INSTANCE = 2;
    public static final int AUDIT_TRAIL = 3;
    private static final String SEPARATOR_ERROR_MESSAGE = "ERROR: one of the parameter is either null or contains one of the reserved symbols \"\u00a7, %, &, `, \u00b5\" in:";
    public static final String LOGGER = "de.renew.mxml.mxmllogger";
    public static final String FILE = System.getProperty("user.home") + File.separator + "renewlogs" + File.separator + "WorkflowLog.txt";
    public static final String FATAL = "F";
    private static boolean _lock = false;
    private boolean _state = false;
    private String _userName = "";

    public static MXMLCommandCenter getInstance() {
        return MXMLHolder.INSTANCE;
    }

    private MXMLCommandCenter() {
    }

    public boolean isOn() {
        return this._state;
    }

    public void changeState(boolean state) {
        if (!MXMLCommandCenter.isLocked()) {
            this._state = state;
        }
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public static String setNumberOfAttributes(int number) {
        return "" + number;
    }

    public static String setAttribute(String name, String param, boolean isFirstAttr, boolean isLastAttr) {
        Object ret = "";
        if (MXMLCommandCenter.containsSeparator(name) || MXMLCommandCenter.containsSeparator(param)) {
            System.err.println(SEPARATOR_ERROR_MESSAGE);
            new Throwable().printStackTrace();
        } else {
            if (isFirstAttr) {
                ret = AUDIT_TRAIL_SEP;
            }
            ret = (String)ret + name + ATRIBUTE_SEP + param;
            if (!isLastAttr) {
                ret = (String)ret + DATA_SEP;
            }
        }
        return ret;
    }

    public static String setProcessInsAttribute(String name, String param, boolean isFirstAttr, boolean isLastAttr) {
        Object ret = "";
        if (MXMLCommandCenter.containsSeparator(name) || MXMLCommandCenter.containsSeparator(param)) {
            System.err.println(SEPARATOR_ERROR_MESSAGE);
            new Throwable().printStackTrace();
        } else {
            if (isFirstAttr) {
                ret = PROCESS_INST_SEP;
            }
            ret = (String)ret + name + ATRIBUTE_SEP + param;
            if (!isLastAttr) {
                ret = (String)ret + DATA_SEP;
            }
        }
        return ret;
    }

    public static String setOwnAuditTrail(String event, String type) {
        Object ret = "";
        if (MXMLCommandCenter.containsSeparator(event) || MXMLCommandCenter.containsSeparator(type)) {
            System.err.println(SEPARATOR_ERROR_MESSAGE);
            new Throwable().printStackTrace();
        } else {
            ret = (String)ret + AUDIT_TRAIL_SEP + event + AUDIT_TRAIL_SEP + type;
        }
        return ret;
    }

    public static String setOwnProcessInstance(String prop) {
        Object ret = "";
        if (MXMLCommandCenter.containsSeparator(prop)) {
            System.err.println(SEPARATOR_ERROR_MESSAGE);
            new Throwable().printStackTrace();
        } else {
            int temp = 0;
            for (int i = 0; i < prop.length(); ++i) {
                temp += prop.charAt(i);
            }
            ret = (String)ret + PROCESS_INST_SEP + (temp += 1000) + PROCESS_INST_SEP + prop;
        }
        return ret;
    }

    public static String setOwnProcess(String procProp) {
        Object ret = "";
        if (MXMLCommandCenter.containsSeparator(procProp)) {
            System.err.println(SEPARATOR_ERROR_MESSAGE);
            new Throwable().printStackTrace();
        } else {
            int temp = 0;
            for (int i = 0; i < procProp.length(); ++i) {
                temp += procProp.charAt(i);
            }
            ret = PROCESS_SEP + (temp += 1000) + PROCESS_SEP + procProp;
        }
        return ret;
    }

    public static boolean isLocked() {
        return _lock;
    }

    public static void lockEnvironment() {
        _lock = true;
        MXMLCommandCenter.getInstance().changeState(false);
        MXMLCommandCenter.getInstance().changeState(false);
        Logger logger = Logger.getLogger(MXMLCommandCenter.class);
        logger.setLevel(Level.FATAL);
        logger.fatal((Object)"Cannot log event, MXML log file has been deleted. Restart the application to continue logging.\n The MXMLLoggin mechanism has been severely destabilized and has been shut down");
        logger.setLevel(Level.DEBUG);
    }

    public String closeDocument() {
        BufferedReader br = null;
        BufferedWriter out = null;
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmssZ");
        try {
            br = new BufferedReader(new FileReader(FILE));
            String sCurrentLine = br.readLine();
            if (sCurrentLine == null || sCurrentLine.equals("")) {
                System.out.println("INFO: Log file empty");
                br.close();
                return "";
            }
            String st = System.getProperty("user.home") + File.separator + "renewlogs" + File.separator + "WorkflowLog" + format.format(date) + ".mxml";
            out = new BufferedWriter(new FileWriter(st));
            out.write(sCurrentLine);
            while ((sCurrentLine = br.readLine()) != null) {
                out.write(sCurrentLine);
            }
            out.write("</ProcessInstance></Process></WorkflowLog>");
            System.out.println("INFO: MXML log file succesfully saved as " + st);
            if (br != null) {
                br.close();
            }
            if (out != null) {
                out.close();
            }
            return st;
        }
        catch (IOException ex) {
            MXMLCommandCenter.lockEnvironment();
            return FATAL;
        }
    }

    public static String formatConstant(String name, String value, int layer) {
        Object ret = "";
        if (!MXMLCommandCenter.containsSeparator(name) && !MXMLCommandCenter.containsSeparator(value)) {
            if (layer == 3) {
                ret = AUDIT_TRAIL_SEP + name + AUDIT_TRAIL_SEP + value;
            } else if (layer == 2) {
                ret = PROCESS_INST_SEP + value + PROCESS_INST_SEP + name;
            } else if (layer == 1) {
                ret = PROCESS_SEP + value + PROCESS_SEP + name;
            } else {
                System.err.println("ERROR: unspecified layer at parameter");
                new Throwable().printStackTrace();
            }
        } else {
            System.err.println(SEPARATOR_ERROR_MESSAGE);
            new Throwable().printStackTrace();
        }
        return ret;
    }

    private static boolean containsSeparator(String prop) {
        return prop == null || prop.equals("") || prop.contains(PROCESS_INST_SEP) || prop.contains(AUDIT_TRAIL_SEP) || prop.contains(DATA_SEP) || prop.contains(ATRIBUTE_SEP) || prop.contains(PROCESS_SEP);
    }

    private static class MXMLHolder {
        public static final MXMLCommandCenter INSTANCE = new MXMLCommandCenter();

        private MXMLHolder() {
        }
    }
}

