/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging;

import de.renew.logging.CliColor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayout
extends org.apache.log4j.PatternLayout {
    private static final SimpleDateFormat DATE_FORMAT;
    private static final HashMap<Level, CliColor> LEVELS;

    public static String leftPad(String str, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        if (str.length() < length) {
            StringBuilder stringBuilder = new StringBuilder(str);
            for (int i = str.length(); i < length; ++i) {
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        return str;
    }

    public String format(LoggingEvent event) {
        return String.format("%s %s %s %s\n", DATE_FORMAT.format(new Date()), this.formatLevel(event), this.formatLocationInfo(event), this.formatMessage(event));
    }

    private String formatLevel(LoggingEvent event) {
        Level level = event.getLevel();
        String levelName = PatternLayout.leftPad(level.toString(), 5);
        CliColor ansiConfig = LEVELS.get(level);
        if (ansiConfig == null) {
            return CliColor.color(levelName, CliColor.BOLD);
        }
        return CliColor.color(levelName, CliColor.BOLD, ansiConfig);
    }

    private String formatLocationInfo(LoggingEvent event) {
        LocationInfo locationInfo = event.getLocationInformation();
        String line = locationInfo.getLineNumber();
        String className = locationInfo.getClassName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return "[\u001b[0;33m" + className + ":" + line + "\u001b[m]";
    }

    private String formatMessage(LoggingEvent event) {
        if (event.getMessage() == null) {
            return "";
        }
        return event.getMessage().toString();
    }

    static {
        LEVELS = new HashMap();
        LEVELS.put(Level.TRACE, CliColor.BLUE);
        LEVELS.put(Level.DEBUG, CliColor.CYAN);
        LEVELS.put(Level.INFO, CliColor.GREEN);
        LEVELS.put(Level.WARN, CliColor.YELLOW);
        LEVELS.put(Level.ERROR, CliColor.RED);
        LEVELS.put(Level.FATAL, CliColor.RED);
        DATE_FORMAT = new SimpleDateFormat("HH:mm:ss,SSS");
    }
}

