/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInOut;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.log4j.Logger;

public class StorableOutput
extends StorableInOut {
    public static Logger logger = Logger.getLogger(StorableOutput.class);
    private PrintWriter fStream;
    private int fIndent;

    public StorableOutput(File file) throws FileNotFoundException {
        this(file.toURI(), new FileOutputStream(file));
    }

    public StorableOutput(OutputStream stream) {
        this(null, stream);
    }

    private StorableOutput(URI location, OutputStream stream) {
        super(location);
        try {
            this.fStream = new PrintWriter(new OutputStreamWriter(stream, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"UTF-8 not supported!");
            this.fStream = new PrintWriter(stream);
        }
        this.fIndent = 0;
    }

    public void writeStorable(Storable storable) {
        if (storable == null) {
            this.fStream.print("NULL");
            this.space();
            return;
        }
        if (this.mapped(storable)) {
            this.writeRef(storable);
            return;
        }
        this.incrementIndent();
        this.startNewLine();
        this.map(storable);
        this.fStream.print(storable.getClass().getName());
        this.space();
        storable.write(this);
        this.space();
        this.decrementIndent();
    }

    public void writeInt(int i) {
        this.fStream.print(i);
        this.space();
    }

    public void writeColor(Color c) {
        this.writeInt(c.getRed());
        this.writeInt(c.getGreen());
        this.writeInt(c.getBlue());
    }

    public void writeDouble(double d) {
        this.fStream.print(d);
        this.space();
    }

    public void writeBoolean(boolean b) {
        if (b) {
            this.fStream.print(1);
        } else {
            this.fStream.print(0);
        }
        this.space();
    }

    public void writeString(String s) {
        this.fStream.print('\"');
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    this.fStream.print('\\');
                    this.fStream.print('n');
                    continue block6;
                }
                case '\"': {
                    this.fStream.print('\\');
                    this.fStream.print('\"');
                    continue block6;
                }
                case '\\': {
                    this.fStream.print('\\');
                    this.fStream.print('\\');
                    continue block6;
                }
                case '\t': {
                    this.fStream.print('\\');
                    this.fStream.print('\t');
                    continue block6;
                }
                default: {
                    this.fStream.print(c);
                }
            }
        }
        this.fStream.print('\"');
        this.space();
    }

    public void close() {
        this.fStream.close();
    }

    private void writeRef(Storable storable) {
        int ref = this.getRef(storable);
        this.fStream.print("REF");
        this.space();
        this.fStream.print(ref);
        this.space();
    }

    private void incrementIndent() {
        this.fIndent += 4;
    }

    private void decrementIndent() {
        this.fIndent -= 4;
        if (this.fIndent < 0) {
            this.fIndent = 0;
        }
    }

    private void startNewLine() {
        this.fStream.println();
        for (int i = 0; i < this.fIndent; ++i) {
            this.space();
        }
    }

    private void space() {
        this.fStream.print(' ');
    }
}

