/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.DoublePoint;
import java.awt.Point;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BSpline {
    public static Logger logger = Logger.getLogger(BSpline.class);
    public static final int DEFSEGMENTS = 15;
    public static final int DEFDEGREE = 2;
    private Vector<DoublePoint> curvepoints = null;
    private Vector<Point> curvepointsInt = null;
    private boolean curvepointsValid = false;
    private Vector<Point> controlpoints = null;
    private int segments;
    private int degree;

    public BSpline() {
    }

    public BSpline(Vector<Point> points) {
        this.BSplineHelper(points, 15, 2);
    }

    public BSpline(Vector<Point> points, int segments) {
        this.BSplineHelper(points, segments, 2);
    }

    public BSpline(Vector<Point> points, int psegments, int pdegree) {
        this.BSplineHelper(points, psegments, pdegree);
    }

    private void BSplineHelper(Vector<Point> points, int psegments, int pdegree) {
        this.segments = psegments;
        this.degree = pdegree;
        this.setVector(points);
        this.invalidatePointCache();
    }

    public void setSegments(int psegments) {
        if (this.segments != psegments) {
            this.segments = psegments;
            this.invalidatePointCache();
        }
    }

    public void setDegree(int pdegree) {
        if (this.degree != pdegree) {
            this.degree = pdegree;
            this.invalidatePointCache();
        }
    }

    public void setPoints(Vector<Point> points) {
        if (this.isPointCacheValid()) {
            if (!this.theSame(points)) {
                this.setVector(points);
                this.invalidatePointCache();
            }
        } else {
            this.setVector(points);
        }
    }

    public int getSegments() {
        return this.segments;
    }

    public int getDegree() {
        return this.degree;
    }

    public Vector<Point> getCurvepointsInt() {
        this.updatePointCache();
        return this.curvepointsInt;
    }

    public Vector<DoublePoint> getCurvepointsDouble() {
        this.updatePointCache();
        return this.curvepoints;
    }

    public int lineSegment(int i) {
        return (i - 1) / this.segments;
    }

    private void invalidatePointCache() {
        this.curvepointsValid = false;
    }

    private void updatePointCache() {
        if (!this.isPointCacheValid()) {
            this.curvepoints = BSpline.calculateSpline(this.degree, this.segments, this.controlpoints);
            this.curvepointsInt = DoublePoint.convertDoublePointVector(this.curvepoints);
            this.curvepointsValid = true;
        }
    }

    private boolean isPointCacheValid() {
        return this.curvepointsValid;
    }

    private void setVector(Vector<Point> vector) {
        Vector<Point> v = new Vector<Point>();
        int s = vector.size();
        for (int i = 0; i < s; ++i) {
            v.addElement(new Point(vector.elementAt(i)));
        }
        this.controlpoints = v;
    }

    private boolean theSame(Vector<Point> vector) {
        if (vector == null || this.controlpoints == null) {
            return false;
        }
        if (vector.size() != this.controlpoints.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Point p2;
            Point p1 = vector.elementAt(i);
            if (p1.equals(p2 = this.controlpoints.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Vector<DoublePoint> calculateSpline(int mydegree, int sections, Vector<Point> points) {
        int degree;
        int numcontrol = points.size();
        if (numcontrol < (degree = mydegree) + 1) {
            degree = numcontrol - 1;
        }
        if (numcontrol > 2) {
            int numpoints = (numcontrol - 1) * sections;
            Vector<DoublePoint> cpoints = new Vector<DoublePoint>();
            int m = numcontrol + degree;
            double[] us = BSpline.knotvector(m, degree);
            double ustep = 1.0 / (double)numpoints;
            for (int i = 0; i < numpoints; ++i) {
                double u = (double)i * ustep;
                DoublePoint tmppoint = BSpline.sppoint(u, degree, points, us);
                cpoints.addElement(tmppoint);
            }
            cpoints.addElement(new DoublePoint(points.lastElement()));
            return cpoints;
        }
        return DoublePoint.convertPointVector(points);
    }

    private static double[] knotvector(int m, int p) {
        int i;
        int mb = m + 1;
        double[] us = new double[mb];
        int bound = m - p * 2;
        for (i = 0; i < bound; ++i) {
            us[i + p] = 1.0 / (double)bound * (double)i;
        }
        for (i = 0; i < p + 1; ++i) {
            us[i] = 0.0;
            us[mb - 1 - i] = 1.0;
        }
        return us;
    }

    private static double div0(double divident, double divisor) {
        if (divisor == 0.0) {
            return 0.0;
        }
        return divident / divisor;
    }

    private static double[] weightDyn(int mini, int maxi, int p, double[] us, double u) {
        double[] result = new double[maxi + 1 + p];
        for (int ii = mini; ii <= maxi + p; ++ii) {
            result[ii] = us[ii] <= u && u < us[ii + 1] ? 1.0 : 0.0;
        }
        for (int pp = 1; pp <= p; ++pp) {
            for (int ii = mini; ii <= maxi + p - pp; ++ii) {
                result[ii] = BSpline.div0((u - us[ii]) * result[ii], us[ii + pp] - us[ii]) + BSpline.div0((us[ii + pp + 1] - u) * result[ii + 1], us[ii + pp + 1] - us[ii + 1]);
            }
        }
        return result;
    }

    public static DoublePoint sppoint(double u, int p, Vector<Point> points, double[] us) {
        int n = points.size();
        double x = 0.0;
        double y = 0.0;
        int maxi = 0;
        for (int i = 1; i < n; ++i) {
            if (!(us[i] <= u)) continue;
            maxi = i;
        }
        int mini = maxi;
        for (int i = maxi; i >= 0; --i) {
            if (!(u < us[i + p + 1])) continue;
            mini = i;
        }
        double[] weights = BSpline.weightDyn(mini, maxi, p, us, u);
        for (int i = 0; i < n; ++i) {
            if (!(us[i] <= u) || !(u < us[i + p + 1])) continue;
            double w = weights[i];
            Point pt = points.elementAt(i);
            x += w * (double)pt.x;
            y += w * (double)pt.y;
        }
        return new DoublePoint(x, y);
    }
}

