/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.StandardDrawingView;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StandardDrawingViewContainer
extends DefaultMultipleCDockable {
    private final JScrollPane fScrollPane;
    private StandardDrawingView fView;
    private static final int VERTICAL_SCROLL_INCREMENT = 75;
    private static final int HORIZONTAL_SCROLL_INCREMENT = 75;

    public StandardDrawingView getView() {
        return this.fView;
    }

    public StandardDrawingViewContainer(MultipleCDockableFactory<?, ?> factory, StandardDrawingView view) {
        super(factory, new CAction[0]);
        this.setCloseable(true);
        this.setRemoveOnClose(true);
        this.fView = view;
        InputEventForwarder forwarder = new InputEventForwarder();
        view.addMouseListener(forwarder);
        view.addMouseMotionListener(forwarder);
        view.addKeyListener(forwarder);
        this.fScrollPane = new JScrollPane(view, 22, 32);
        this.fScrollPane.getViewport().setScrollMode(1);
        this.fScrollPane.setAutoscrolls(true);
        this.fScrollPane.getVerticalScrollBar().setUnitIncrement(75);
        this.fScrollPane.getHorizontalScrollBar().setUnitIncrement(75);
        this.fScrollPane.addMouseWheelListener(forwarder);
        this.add(this.fScrollPane);
    }

    public JScrollPane getScrollPane() {
        return this.fScrollPane;
    }

    public void clean() {
        this.getView().getParent().remove(this.getView());
        this.fView = null;
    }

    private class InputEventForwarder
    implements KeyListener,
    MouseMotionListener,
    MouseListener,
    MouseWheelListener {
        private boolean active = true;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.mouseExited(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.active) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                ((JPanel)e.getSource()).scrollRectToVisible(r);
                StandardDrawingViewContainer.this.fView.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.mouseMoved(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.keyPressed(e);
            }
            if (this.active && (e.getKeyCode() == 17 || e.getKeyCode() == 157 || e.getKeyCode() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
                StandardDrawingViewContainer.this.fScrollPane.setWheelScrollingEnabled(false);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.active) {
                StandardDrawingViewContainer.this.fView.keyReleased(e);
            }
            if (this.active && (e.getKeyCode() == 17 || e.getKeyCode() == 157 || e.getKeyCode() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
                StandardDrawingViewContainer.this.fScrollPane.setWheelScrollingEnabled(true);
            }
        }

        public void discard() {
            this.active = false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                StandardDrawingViewContainer.this.fView.mouseWheelMoved(e);
                StandardDrawingViewContainer.this.fScrollPane.repaint();
            }
        }
    }
}

