/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import CH.ifa.draw.util.DrawingListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StandardDrawingLookup {
    public static Logger logger = Logger.getLogger(StandardDrawingLookup.class);
    private DrawingView fPreviousView;
    private DrawingView fCurrentView;
    private Map<Drawing, StandardDrawingViewContainer> fOpenedDrawings = new HashMap<Drawing, StandardDrawingViewContainer>();
    private Vector<DrawingListener> fDrawingListeners = new Vector();

    public DrawingView getPreviousView() {
        return this.fPreviousView;
    }

    public void setCurrentView(DrawingView currentView) {
        logger.debug((Object)("Setting current view to " + currentView.drawing().getName()));
        this.fPreviousView = this.fCurrentView;
        this.fCurrentView = currentView;
    }

    public DrawingView getCurrentView() {
        if (this.fCurrentView != null) {
            return this.fCurrentView;
        }
        return NullDrawingView.INSTANCE;
    }

    public StandardDrawingViewContainer getViewContainerForDrawing(Drawing drawing) {
        try {
            return this.fOpenedDrawings.get(drawing);
        }
        catch (Exception e) {
            logger.error((Object)"Tried to retrieve a view container for a drawing that isn't opened.");
            return null;
        }
    }

    public void addViewContainer(Drawing drawing, StandardDrawingViewContainer container) {
        this.fOpenedDrawings.put(drawing, container);
        this.drawingAdded(drawing);
    }

    public void removeViewContainer(Drawing drawing) {
        this.fOpenedDrawings.remove(drawing);
        this.drawingReleased(drawing);
    }

    public Drawing getLoadedDrawingForFile(File file) {
        for (Map.Entry<Drawing, StandardDrawingViewContainer> entry : this.fOpenedDrawings.entrySet()) {
            File filename = entry.getKey().getFilename();
            if (filename == null || !filename.getAbsoluteFile().equals(file.getAbsoluteFile())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Enumeration<Drawing> getAllDrawings() {
        Vector<Drawing> vector = new Vector<Drawing>(this.fOpenedDrawings.keySet());
        return vector.elements();
    }

    public void closeAllDrawings() {
        logger.debug((Object)"Closing all opened drawings.");
        ArrayList<Drawing> allDrawings = Collections.list(this.getAllDrawings());
        allDrawings.sort((d1, d2) -> d2.getName().compareTo(d1.getName()));
        for (Drawing drawingEntry : allDrawings) {
            StandardDrawingViewContainer container = this.fOpenedDrawings.get(drawingEntry);
            if (container == null) continue;
            Drawing drawing = container.getView().drawing();
            container.setVisible(false);
            if (container.isVisible()) continue;
            this.fOpenedDrawings.remove(drawing);
            this.drawingReleased(drawing);
        }
    }

    public void addDrawingListener(DrawingListener listener) {
        this.fDrawingListeners.add(listener);
    }

    public void removeDrawingListener(DrawingListener listener) {
        this.fDrawingListeners.remove(listener);
    }

    private void drawingAdded(Drawing drawing) {
        this.fDrawingListeners.forEach(listener -> listener.drawingAdded(drawing));
    }

    private void drawingReleased(Drawing drawing) {
        this.fDrawingListeners.forEach(listener -> listener.drawingReleased(drawing));
        if (this.fPreviousView != null && this.fPreviousView.drawing().equals(drawing)) {
            this.fPreviousView = NullDrawingView.INSTANCE;
        }
        if (this.fCurrentView != null && this.fCurrentView.drawing().equals(drawing)) {
            this.fCurrentView = this.fPreviousView;
            this.fPreviousView = NullDrawingView.INSTANCE;
        }
    }
}

