/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.GridConstrainer;
import CH.ifa.draw.util.GUIProperties;
import de.renew.plugin.PluginProperties;
import java.awt.Point;
import java.util.Properties;

public class SnapToGridCommand
extends UndoableCommand {
    private Point fGrid;

    public SnapToGridCommand(String name) {
        super(name);
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        PointConstrainer grid = view.getConstrainer();
        if (grid == null) {
            int size;
            DrawPlugin current = DrawPlugin.getCurrent();
            if (current == null) {
                Properties properties = GUIProperties.getProperties();
                size = ((PluginProperties)properties).getIntProperty("ch.ifa.draw.grid.size", 5);
            } else {
                current.showStatus("No active grid - using default grid.");
                size = current.getProperties().getIntProperty("ch.ifa.draw.grid.size", 5);
            }
            this.fGrid = new Point(size, size);
            grid = new GridConstrainer(this.fGrid.x, this.fGrid.y);
        }
        FigureEnumeration selection = view.selectionElements();
        while (selection.hasMoreElements()) {
            Figure f = selection.nextFigure();
            Point c = f.center();
            Point cc = grid.constrainPoint(f.center());
            f.moveBy(cc.x - c.x, cc.y - c.y);
        }
        view.checkDamage();
        return true;
    }
}

