/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class SelectAreaTracker
extends AbstractTool {
    protected Rectangle fSelectGroup;
    private Rectangle fVisualSelectGroup;
    private Point fVisualAnchor;

    public SelectAreaTracker(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.fVisualAnchor = new Point(e.getX(), e.getY());
        this.visualRubberBand(this.fVisualAnchor.x, this.fVisualAnchor.y, this.fVisualAnchor.x, this.fVisualAnchor.y);
        this.selectionRubberBand(this.fAnchorX, this.fAnchorY, this.fAnchorX, this.fAnchorY);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.eraseRubberBand();
        this.visualRubberBand(this.fVisualAnchor.x, this.fVisualAnchor.y, e.getX(), e.getY());
        this.selectionRubberBand(this.fAnchorX, this.fAnchorY, x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        this.eraseRubberBand();
        this.selectGroup(e.isShiftDown());
        this.fSelectGroup = null;
        this.fVisualSelectGroup = null;
    }

    private void visualRubberBand(int x1, int y1, int x2, int y2) {
        this.fVisualSelectGroup = new Rectangle(new Point(x1, y1));
        this.fVisualSelectGroup.add(new Point(x2, y2));
        this.drawXORRect(this.fVisualSelectGroup);
    }

    private void selectionRubberBand(int x1, int y1, int x2, int y2) {
        this.fSelectGroup = new Rectangle(new Point(x1, y1));
        this.fSelectGroup.add(new Point(x2, y2));
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.fVisualSelectGroup);
    }

    private void drawXORRect(Rectangle r) {
        Graphics g = this.view().getGraphics();
        this.drawXORRect(r, g);
    }

    private void drawXORRect(Rectangle r, Graphics g) {
        g.setXORMode(this.view().getBackground());
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    protected void selectGroup(boolean toggle) {
        FigureEnumeration k = this.drawing().figuresReverse();
        Vector<Figure> concernedFigures = new Vector<Figure>();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle r2 = figure.displayBox();
            if (!this.fSelectGroup.contains(r2.x, r2.y) || !this.fSelectGroup.contains(r2.x + r2.width, r2.y + r2.height)) continue;
            concernedFigures.addElement(figure);
        }
        if (toggle) {
            this.view().toggleSelectionAll(concernedFigures);
        } else {
            this.view().addToSelectionAll(concernedFigures);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.fVisualSelectGroup != null) {
            this.drawXORRect(this.fVisualSelectGroup, g);
        }
    }
}

