/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.SubstringMatcher;
import CH.ifa.draw.util.GUIProperties;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SearchReplaceFrame {
    public static final int SEARCHMODE = 0;
    public static final int SEARCHREPLACEMODE = 1;
    private Enumeration<Drawing> drawings;
    private Set<Drawing> drawingsSet;
    private FigureEnumeration figures;
    private Drawing drawing;
    private JFrame frame;
    private boolean stringMatcherValid = false;
    private SubstringMatcher substringMatcher;
    private int mode;
    private boolean cancelSearchInAllDrawings = true;
    private boolean searchAll = true;
    private boolean ignoreCase = true;
    private boolean newSearch = true;

    public SearchReplaceFrame(int aMode) {
        this.mode = aMode;
        String frameTitle = this.mode == 0 ? "Search" : "Search & Replace";
        this.frame = new JFrame(frameTitle);
        if (!GUIProperties.avoidFrameReshape()) {
            this.frame.setSize(600, 200);
        }
        GridBagLayout gridBag = new GridBagLayout();
        this.frame.getContentPane().setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JLabel label = new JLabel("Search for:");
        gridBag.setConstraints(label, c);
        this.frame.getContentPane().add(label);
        c.gridwidth = 0;
        final JTextField searchTextField = new JTextField("", 30);
        gridBag.setConstraints(searchTextField, c);
        searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SearchReplaceFrame.this.reset();
            }
        });
        this.frame.getContentPane().add(searchTextField);
        final JTextField replaceTextField = new JTextField("", 30);
        if (this.mode == 1) {
            c.gridwidth = 1;
            label = new JLabel("Replace with:");
            gridBag.setConstraints(label, c);
            this.frame.getContentPane().add(label);
            c.gridwidth = 0;
            gridBag.setConstraints(replaceTextField, c);
            replaceTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SearchReplaceFrame.this.stringMatcherValid = false;
                }
            });
            this.frame.getContentPane().add(replaceTextField);
        }
        JCheckBox searchAllCheckBox = new JCheckBox("Search all drawings", this.searchAll);
        this.frame.getContentPane().add(searchAllCheckBox);
        searchAllCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SearchReplaceFrame.this.searchAll = !SearchReplaceFrame.this.searchAll;
                SearchReplaceFrame.this.reset();
            }
        });
        c.gridwidth = 13;
        gridBag.setConstraints(searchAllCheckBox, c);
        JCheckBox ignoreCaseCheckBox = new JCheckBox("Ignore case", this.ignoreCase);
        this.frame.getContentPane().add(ignoreCaseCheckBox);
        ignoreCaseCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SearchReplaceFrame.this.ignoreCase = !SearchReplaceFrame.this.ignoreCase;
            }
        });
        c.gridwidth = 0;
        gridBag.setConstraints(ignoreCaseCheckBox, c);
        c.weightx = 1.0;
        String buttonTitle = this.mode == 0 ? "Search" : "Search & Replace";
        JButton searchButton = new JButton(buttonTitle);
        gridBag.setConstraints(searchButton, c);
        this.frame.getContentPane().add(searchButton);
        this.frame.getRootPane().setDefaultButton(searchButton);
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("".equals(searchTextField.getText())) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (!SearchReplaceFrame.this.stringMatcherValid) {
                    SearchReplaceFrame.this.substringMatcher = SearchReplaceFrame.this.mode == 0 ? new SubstringMatcher(searchTextField.getText(), null) : new SubstringMatcher(searchTextField.getText(), replaceTextField.getText());
                    SearchReplaceFrame.this.stringMatcherValid = true;
                }
                SearchReplaceFrame.this.searchInDrawings();
            }
        });
        c.gridwidth = 0;
        JButton cancelButton = new JButton("Cancel");
        gridBag.setConstraints(cancelButton, c);
        this.frame.getContentPane().add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceFrame.this.cancel();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                SearchReplaceFrame.this.frame.setVisible(false);
                MenuManager.getInstance().getWindowsMenu().removeFrame(SearchReplaceFrame.this.frame);
            }
        });
        this.frame.pack();
        this.reset();
    }

    private void handleFoundFigure(TextFigure foundFigure) {
        if (this.mode == 1) {
            String foundText = foundFigure.getText();
            String replacement = "";
            int nextFromIndex = 0;
            while (this.substringMatcher.matches(foundText, nextFromIndex, this.ignoreCase)) {
                replacement = this.substringMatcher.replacement(foundText, nextFromIndex);
                int index = this.substringMatcher.indexOf(foundText, nextFromIndex);
                int answer = JOptionPane.showConfirmDialog(this.frame, "Replace:\n" + foundText + "\nwith:\n" + replacement, "Confirm Replacement", 1);
                switch (answer) {
                    case 2: {
                        this.reset();
                        this.cancelSearchInAllDrawings = true;
                        this.setVisible(false);
                        return;
                    }
                    case 0: {
                        DrawApplication application = DrawPlugin.getGui();
                        application.prepareUndoSnapshot();
                        foundFigure.setText(replacement);
                        foundText = replacement;
                        nextFromIndex = index + this.substringMatcher.getReplaceString().length();
                        application.commitUndoSnapshot();
                        application.view().checkDamage();
                        break;
                    }
                    case 1: {
                        nextFromIndex = index + this.substringMatcher.getSearchString().length();
                    }
                }
            }
        }
    }

    private void searchInDrawings() {
        if (this.mode == 1) {
            this.reset();
        } else if (!this.drawing.equals(DrawPlugin.getGui().drawing()) && !this.searchAll) {
            this.reset();
        }
        if (this.mode == 0 && this.searchAll) {
            HashSet<Drawing> currentDrawingsSet = new HashSet<Drawing>();
            Enumeration<Drawing> currentDrawings = DrawPlugin.getGui().drawings();
            while (currentDrawings.hasMoreElements()) {
                currentDrawingsSet.add(currentDrawings.nextElement());
            }
            if (!currentDrawingsSet.equals(this.drawingsSet)) {
                this.reset();
            }
        }
        TextFigure foundFigure = null;
        this.cancelSearchInAllDrawings = false;
        while (!this.cancelSearchInAllDrawings && (this.drawings.hasMoreElements() || this.drawing != null)) {
            if (this.newSearch) {
                this.newSearch = false;
                if (this.drawings.hasMoreElements()) {
                    this.drawing = this.drawings.nextElement();
                    this.figures = this.drawing.figures();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            if ((foundFigure = this.searchInOneDrawing()) != null) {
                FigureException e;
                DrawApplication application = DrawPlugin.getGui();
                if (this.mode == 0) {
                    e = new FigureException("Heureka", 1, this.substringMatcher.getLastposition() + 1, this.drawing, foundFigure);
                    application.selectOffendingElements(e);
                    return;
                }
                e = new FigureException("Heureka", "", this.drawing, foundFigure);
                application.selectOffendingElements(e);
                this.handleFoundFigure(foundFigure);
                continue;
            }
            this.newSearch = true;
            this.drawing = null;
        }
        if (!this.cancelSearchInAllDrawings && !this.figures.hasMoreElements() & foundFigure == null) {
            Toolkit.getDefaultToolkit().beep();
            this.reset();
        }
    }

    private TextFigure searchInOneDrawing() {
        while (this.figures.hasMoreElements()) {
            TextFigure textFigure;
            String figureText;
            Figure figure = this.figures.nextFigure();
            if (!(figure instanceof TextFigure) || !this.substringMatcher.matches(figureText = (textFigure = (TextFigure)figure).getText(), this.ignoreCase)) continue;
            return textFigure;
        }
        return null;
    }

    protected void reset() {
        DrawApplication application = DrawPlugin.getGui();
        if (application != null) {
            application.tool().deactivate();
            this.drawing = application.drawing();
            if (this.searchAll) {
                this.drawings = application.drawings();
                this.drawingsSet = new HashSet<Drawing>();
                while (this.drawings.hasMoreElements()) {
                    this.drawingsSet.add(this.drawings.nextElement());
                }
                this.drawings = application.drawings();
            } else {
                Vector<Drawing> list = new Vector<Drawing>();
                list.add(this.drawing);
                this.drawings = list.elements();
                this.drawingsSet = new HashSet<Drawing>(list);
            }
            this.figures = this.drawing.figures();
            this.newSearch = true;
            this.stringMatcherValid = false;
        }
    }

    private void cancel() {
        this.setVisible(false);
        DrawPlugin.getGui().toolDone();
    }

    protected void setVisible(boolean b) {
        this.frame.setVisible(b);
        if (b) {
            MenuManager.getInstance().getWindowsMenu().addFrame("Tools", this.frame);
        } else {
            MenuManager.getInstance().getWindowsMenu().removeFrame(this.frame);
        }
    }
}

