/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseAttributeCommand;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class QueryAttributeCommand
extends ChooseAttributeCommand {
    JTextField input;
    public static Logger logger = Logger.getLogger(QueryAttributeCommand.class);

    public QueryAttributeCommand(String displayName, String name, String attributeName, Class<?> type) {
        super(displayName, name, attributeName, type);
    }

    @Override
    protected void specializeDialog() {
        this.input = new JTextField();
        this.dialog.getContentPane().add((Component)this.input, "Center");
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    QueryAttributeCommand.this.apply();
                } else if (e.getKeyCode() == 27) {
                    ChooseAttributeCommand.closeDialog(QueryAttributeCommand.this.dialog);
                }
            }
        });
        this.dialog.pack();
    }

    @Override
    protected void updateFromFigure() {
        DrawingView view = this.getEditor().view();
        Object value = null;
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(this.fAttribute);
            if (val == null) continue;
            if (value != null && !value.equals(val)) {
                value = null;
                break;
            }
            value = val;
        }
        String valuestr = "";
        if (value != null) {
            valuestr = value.toString();
        }
        this.input.setText(valuestr);
        this.resetFocus();
    }

    private void resetFocus() {
        this.input.requestFocus();
        this.input.setSelectionStart(0);
        this.input.setSelectionEnd(this.input.getText().length());
    }

    @Override
    protected void apply() {
        Object value;
        block8: {
            String valuestr = this.input.getText();
            value = null;
            try {
                if (this.type == Integer.class) {
                    value = Integer.valueOf(valuestr);
                } else if (this.type == String.class) {
                    if (this.fAttribute.equals("LineStyle") && (valuestr.startsWith("0") || !valuestr.matches("(\\d+( \\d+)*)?"))) {
                        logger.error((Object)("In the '" + this.displayName + "' dialog only numbers separated by a dash or a gap are allowed. String should not start with 0 (zero)."));
                    } else {
                        value = valuestr;
                    }
                }
            }
            catch (NumberFormatException ex) {
                logger.error((Object)ex.getMessage());
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)(QueryAttributeCommand.class.getSimpleName() + ": \n" + String.valueOf(ex)));
            }
        }
        if (value != null) {
            new ChangeAttributeCommand("", this.fAttribute, value).execute();
        }
        this.resetFocus();
    }
}

