/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InfoDialog
extends JDialog {
    private Logger logger = Logger.getLogger(InfoDialog.class);
    protected JButton button;
    protected MultiLineLabel label;

    public InfoDialog(JFrame parent, String title, String message) {
        super(parent, title, true);
        this.getContentPane().setLayout(new BorderLayout(15, 15));
        this.label = new MultiLineLabel(message, 20, 20);
        this.getContentPane().add("Center", this.label);
        this.button = new JButton("OK");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoDialog.this.dispose();
            }
        };
        this.button.addActionListener(listener);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1, 15, 15));
        p.add(this.button);
        this.getContentPane().add("South", p);
        this.pack();
    }

    public InfoDialog(JFrame parent, String title, String message, boolean addRenewLink) {
        super(parent, title, true);
        try {
            this.getContentPane().setLayout(new BorderLayout(15, 15));
            JLabel jLabel = new JLabel("<html>" + message + "</html>");
            jLabel.setOpaque(true);
            JPanel aboutPanel = new JPanel();
            aboutPanel.setLayout(new BoxLayout(aboutPanel, 3));
            aboutPanel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 25));
            aboutPanel.add(jLabel);
            aboutPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            aboutPanel = this.createLinkLabel(aboutPanel, "http://www.renew.de", false);
            if (addRenewLink) {
                aboutPanel = this.createLinkLabel(aboutPanel, "http://www.paose.net", false);
            }
            aboutPanel = this.createLinkLabel(aboutPanel, "mailto:support@renew.de", true);
            this.getContentPane().add("Center", aboutPanel);
            this.button = new JButton("OK");
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InfoDialog.this.dispose();
                }
            };
            this.button.addActionListener(listener);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1, 15, 15));
            p.add(this.button);
            this.getContentPane().add("South", p);
            this.pack();
        }
        catch (Exception e) {
            this.logger.error((Object)("InfoDialog " + String.valueOf(e)));
        }
    }

    private JPanel createLinkLabel(JPanel helpPanel, String url, boolean mail) {
        Object linkaddress;
        String linktitle;
        if (mail) {
            if (url.startsWith("mailto:")) {
                linktitle = url.replaceFirst("mailto:", "");
                linkaddress = url;
            } else {
                linktitle = url;
                linkaddress = "mailto:" + url;
            }
        } else {
            linktitle = url;
            linkaddress = url;
        }
        JLabel pageurl = new JLabel("<html><a href=\"" + (String)linkaddress + "\">" + linktitle + "</a></html>");
        pageurl.setCursor(new Cursor(12));
        pageurl.addMouseListener(new MouseAdapter((String)linkaddress, mail){
            final /* synthetic */ String val$linkaddress;
            final /* synthetic */ boolean val$mail;
            {
                this.val$linkaddress = string;
                this.val$mail = bl;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() > 0) {
                    InfoDialog.this.openURL(this.val$linkaddress, this.val$mail);
                }
            }
        });
        helpPanel.add(pageurl);
        return helpPanel;
    }

    private void openURL(String url, boolean mail) {
        block4: {
            try {
                Desktop desktop = Desktop.getDesktop();
                URI uri = URI.create(url);
                if (mail) {
                    desktop.mail(uri);
                } else {
                    desktop.browse(uri);
                }
            }
            catch (IOException e) {
                this.logger.error((Object)(InfoDialog.class.getSimpleName() + ": could not open link " + url + "."));
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)(InfoDialog.class.getSimpleName() + ": " + String.valueOf(e)));
            }
        }
    }
}

