/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class ChooseAttributeCommand
extends Command {
    static final String WINDOWS_CATEGORY_ATTRIBUTES = "Attributes";
    protected JFrame lastParent;
    protected JDialog dialog;
    protected String fAttribute;
    protected Class<?> type;
    protected String displayName;

    public ChooseAttributeCommand(String displayName, String name, String attributeName, Class<?> type) {
        super(name);
        this.fAttribute = attributeName;
        this.displayName = displayName;
        this.type = type;
    }

    protected void createDialog() {
        JFrame parent = DrawPlugin.getGui().getFrame();
        if (this.dialog != null) {
            if (this.lastParent == parent) {
                return;
            }
            this.dialog.dispose();
        }
        this.dialog = new JDialog((Frame)parent, "Change " + this.displayName + ":");
        this.lastParent = parent;
        JButton apply = new JButton(" Apply ");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseAttributeCommand.this.apply();
            }
        });
        JButton update = new JButton(" Update ");
        update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseAttributeCommand.this.updateFromFigure();
            }
        });
        JButton ok = new JButton(" OK ");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseAttributeCommand.this.apply();
                ChooseAttributeCommand.closeDialog(ChooseAttributeCommand.this.dialog);
            }
        });
        JButton cancel = new JButton(" Cancel ");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseAttributeCommand.closeDialog(ChooseAttributeCommand.this.dialog);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(apply);
        panel.add(update);
        panel.add(ok);
        panel.add(cancel);
        this.dialog.getContentPane().add((Component)panel, "South");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChooseAttributeCommand.closeDialog(ChooseAttributeCommand.this.dialog);
            }
        });
        this.specializeDialog();
    }

    protected abstract void specializeDialog();

    protected abstract void updateFromFigure();

    protected abstract void apply();

    @Override
    public void execute() {
        this.createDialog();
        this.updateFromFigure();
        this.dialog.setVisible(true);
        MenuManager.getInstance().getWindowsMenu().addDialog(WINDOWS_CATEGORY_ATTRIBUTES, this.dialog);
    }

    protected DrawingEditor getEditor() {
        DrawPlugin plugin = DrawPlugin.getCurrent();
        return plugin == null ? NullDrawingEditor.INSTANCE : plugin.getDrawingEditor();
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    protected static void closeDialog(JDialog dialog) {
        MenuManager.getInstance().getWindowsMenu().removeDialog(dialog);
        dialog.setVisible(false);
    }
}

