/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class DrawingFileHelper {
    public static Logger logger = Logger.getLogger(DrawingFileHelper.class);
    public static final int FILEVERSION = 11;
    private static StorableInputDrawingLoader loader = new StorableInputDrawingLoader();

    private DrawingFileHelper() {
    }

    private static Drawing toDrawing(PositionedDrawing posDrawing) {
        return posDrawing == null ? null : posDrawing.getDrawing();
    }

    private static List<Drawing> toDrawingList(List<PositionedDrawing> posDrawings) {
        ArrayList<Drawing> drawings = new ArrayList<Drawing>(posDrawings.size());
        for (PositionedDrawing d : posDrawings) {
            drawings.add(d.getDrawing());
        }
        return drawings;
    }

    public static Drawing loadDrawing(File file, StatusDisplayer sd) {
        return DrawingFileHelper.toDrawing(DrawingFileHelper.loadPositionedDrawing(file, sd));
    }

    public static List<Drawing> loadDrawingList(File file, StatusDisplayer sd) {
        return DrawingFileHelper.toDrawingList(DrawingFileHelper.loadPositionedDrawingList(file, sd));
    }

    public static Drawing loadDrawing(InputStream stream, String name) throws FileNotFoundException, IOException {
        return DrawingFileHelper.toDrawing(DrawingFileHelper.loadPositionedDrawing(stream, name));
    }

    public static Drawing loadDrawing(URL location, StatusDisplayer sd) {
        return DrawingFileHelper.toDrawing(DrawingFileHelper.loadPositionedDrawing(location, sd));
    }

    public static List<Drawing> loadDrawingList(URL location, StatusDisplayer sd) {
        return DrawingFileHelper.toDrawingList(DrawingFileHelper.loadPositionedDrawingList(location, sd));
    }

    public static PositionedDrawing loadPositionedDrawing(File file, StatusDisplayer sd) {
        List<PositionedDrawing> drawings = DrawingFileHelper.loadPositionedDrawingList(file, sd);
        int size = drawings.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            logger.warn((Object)("Loaded multiple nets from " + String.valueOf(file) + ", but only creating a drawing for the first"));
        }
        return drawings.get(0);
    }

    public static List<PositionedDrawing> loadPositionedDrawingList(File file, StatusDisplayer sd) {
        if (sd == null) {
            sd = DrawPlugin.getGui();
        }
        try {
            URL url = file.toURI().toURL();
            List<PositionedDrawing> posDrawings = DrawingFileHelper.loadPositionedDrawingList(url, sd);
            if (posDrawings != null) {
                for (PositionedDrawing d : posDrawings) {
                    Drawing drawing = d.getDrawing();
                    if (drawing == null) continue;
                    drawing.setName(StringUtil.getFilename((String)file.getName()));
                    drawing.setFilename(file);
                }
            }
            return posDrawings;
        }
        catch (IOException e) {
            sd.showStatus("Error " + String.valueOf(e));
            return Collections.emptyList();
        }
    }

    public static PositionedDrawing loadPositionedDrawing(InputStream stream, String name) throws FileNotFoundException, IOException {
        Drawing drawing;
        logger.debug((Object)("Loading drawing from " + String.valueOf(stream) + "..."));
        PositionedDrawing posDrawing = loader.readFromStorableInput(stream);
        if (posDrawing != null && (drawing = posDrawing.getDrawing()) != null) {
            drawing.setName(name);
            if (drawing instanceof Figure) {
                ((Figure)((Object)drawing)).invalidate();
            }
        }
        return posDrawing;
    }

    public static PositionedDrawing loadPositionedDrawing(URL location, StatusDisplayer sd) {
        List<PositionedDrawing> drawings = DrawingFileHelper.loadPositionedDrawingList(location, sd);
        int size = drawings.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            logger.warn((Object)("Loaded multiple nets from " + String.valueOf(location) + ", but only creating a drawing for the first"));
        }
        return drawings.get(0);
    }

    public static List<PositionedDrawing> loadPositionedDrawingList(URL location, StatusDisplayer sd) {
        logger.debug((Object)("Loading drawing from " + String.valueOf(location) + "..."));
        if (sd == null) {
            sd = DrawPlugin.getGui();
        }
        if (DrawPlugin.getCurrent() != null) {
            ImportFormat[] allImportFormats;
            for (ImportFormat importFormat : allImportFormats = DrawPlugin.getCurrent().getImportHolder().allImportFormats()) {
                if (!importFormat.canImport(location)) continue;
                try {
                    List<Drawing> drawings = importFormat.importFiles(new URL[]{location});
                    ArrayList<PositionedDrawing> posDrawings = new ArrayList<PositionedDrawing>(drawings.size());
                    for (Drawing d : drawings) {
                        posDrawings.add(new PositionedDrawing(null, null, d));
                    }
                    return posDrawings;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    logger.debug((Object)e);
                }
            }
        }
        try {
            PositionedDrawing posDrawing = loader.readFromStorableInput(location, sd);
            if (posDrawing != null) {
                Drawing drawing = posDrawing.getDrawing();
                if (drawing != null) {
                    String file = location.getFile();
                    drawing.setName(StringUtil.getFilename((String)file));
                    drawing.setFilename(new File(file));
                    if (drawing instanceof Figure) {
                        ((Figure)((Object)drawing)).invalidate();
                    }
                }
                return Collections.singletonList(posDrawing);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Could not open Drawing: " + location.toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawingFileHelper.class.getSimpleName() + ": " + String.valueOf(e)));
            }
            sd.showStatus("Error " + String.valueOf(e));
        }
        return Collections.emptyList();
    }

    public static File deriveBackupFile(File file) {
        File backupFile = new File(file.getParent(), StringUtil.stripFilenameExtension((String)file.getName()) + ".bak");
        if (backupFile.equals(file)) {
            return null;
        }
        return backupFile;
    }

    public static boolean saveDrawing(Drawing drawing, File file, StatusDisplayer sd) {
        return DrawingFileHelper.savePositionedDrawing(new PositionedDrawing(null, null, drawing), file, sd);
    }

    public static boolean savePositionedDrawing(PositionedDrawing positionedDrawing, File file, StatusDisplayer sd) {
        File backupFile;
        Drawing drawing = positionedDrawing.getDrawing();
        if (!drawing.getBackupStatus() && (backupFile = DrawingFileHelper.deriveBackupFile(file)) != null && file.exists()) {
            logger.debug((Object)("Creating backup file " + String.valueOf(backupFile) + "..."));
            if (file.renameTo(backupFile)) {
                drawing.setBackupStatus(true);
            } else {
                logger.error((Object)("Could not create backup file " + String.valueOf(backupFile) + "!"));
                logger.error((Object)("Original filename is " + String.valueOf(file)));
            }
        }
        logger.debug((Object)("Saving drawing as " + String.valueOf(file) + "..."));
        try {
            DrawingFileHelper.saveAsStorableOutput(drawing, file, positionedDrawing.getWindowLocation(), positionedDrawing.getWindowDimension(), true);
            return true;
        }
        catch (IOException e) {
            sd.showStatus("Error " + String.valueOf(e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsStorableOutput(Drawing drawing, File file, Point loc, Dimension size, boolean clearModified) throws IOException {
        drawing.lock();
        try {
            StorableOutput output = new StorableOutput(file);
            output.writeInt(11);
            output.writeStorable(drawing);
            if (loc != null && size != null) {
                output.writeInt(loc.x);
                output.writeInt(loc.y);
                output.writeInt(size.width);
                output.writeInt(size.height);
            }
            output.close();
            if (clearModified) {
                drawing.clearModified();
            }
        }
        finally {
            drawing.unlock();
        }
    }

    public static File checkAndAddExtension(File file, SimpleFileFilter ff) {
        File result = file;
        if (file != null && ff != null && !ff.accept(file)) {
            result = new File(file.getParentFile(), file.getName() + "." + ff.getExtension());
        }
        return result;
    }

    public static void setStorableInputDrawingLoader(StorableInputDrawingLoader newloader) {
        if (newloader == null) {
            throw new NullPointerException("Cannot set null reference as loader.");
        }
        loader = newloader;
    }
}

