/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui.reactivecomponents;

import CH.ifa.draw.gui.reactivecomponents.State;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class Component {
    private final Map<String, State<String>> _states = new HashMap<String, State<String>>();
    private JComponent _graphic;

    protected abstract JComponent render();

    public final JComponent get() {
        this._graphic = this.render();
        return this._graphic;
    }

    public final void update() {
        Container parent = this._graphic.getParent();
        if (parent != null) {
            parent.remove(this._graphic);
            this._graphic = this.render();
            parent.add(this._graphic);
            parent.revalidate();
            parent.repaint();
        }
    }

    protected State<String> useState() {
        String key = "activeKey";
        String plugin = "activePlugin";
        if (this._states.containsKey(key)) {
            if (this._states.get(key).getValue().getClass() != plugin.getClass()) {
                throw new IllegalArgumentException("State " + key + " already exists with type " + String.valueOf(this._states.get(key).getValue().getClass()) + " and cannot be changed to " + String.valueOf(plugin.getClass()));
            }
            return this._states.get(key);
        }
        State<String> state = new State<String>(plugin, this::update);
        this._states.put(key, state);
        return state;
    }
}

