/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui;

import CH.ifa.draw.framework.Toolbar;
import CH.ifa.draw.gui.StorableButtonContainerLayout;
import CH.ifa.draw.gui.ToolButtonContainer;
import CH.ifa.draw.gui.ToolButtonPanel;
import bibliothek.gui.DockUI;
import de.renew.plugin.PluginManager;
import de.renew.windowmanagement.DragCanvas;
import de.renew.windowmanagement.DraggableComponentAdapter;
import de.renew.windowmanagement.DraggableComponentDropTarget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ToolButtonScrollPane
extends DragCanvas
implements Toolbar {
    private static final String IMAGES = "CH/ifa/draw/images/";
    private static final String LAYOUT_PATH = "CH/ifa/draw/gui/";
    private static final Logger LOGGER = Logger.getLogger(ToolButtonScrollPane.class);
    private Properties _persistentLayouts;
    private final ToolButtonPanel _content;
    private final Map<String, Set<AbstractButton>> _registeredButtons = new HashMap<String, Set<AbstractButton>>();
    private final Map<String, String> _groupingLookup = new HashMap<String, String>();
    private final Map<String, AbstractButton> _buttonLookup = new HashMap<String, AbstractButton>();
    private final Map<String, String> _tooltips = new HashMap<String, String>();
    private final JComboBox<String> _chooseToolsComboBox;
    private JComboBox<StorableButtonContainerLayout> _chooseLayoutBox;
    private final Map<String, StorableButtonContainerLayout> _unavailableLayouts = new HashMap<String, StorableButtonContainerLayout>();
    private final Semaphore _semaphore = new Semaphore(1);

    public ToolButtonScrollPane(ToolButtonPanel panel) {
        super((JPanel)panel);
        this.setMinimumSize(new Dimension(70, 0));
        this.getViewport().setScrollMode(1);
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.getHorizontalScrollBar().setUnitIncrement(20);
        this._content = panel;
        this._content.setLayout(new BoxLayout(this._content, 1));
        this._chooseToolsComboBox = new JComboBox();
        this.initComboBox();
        this._content.add(this._chooseToolsComboBox);
        this._content.add(new CreateNewContainerTarget());
        this._content.add(this.createLayoutPanel());
        this.loadInitialButtonLayouts();
    }

    public void storeLayoutsToDisk() {
        try {
            File file = new File(PluginManager.getPreferencesLocation(), "renewButtonLayout.properties");
            FileOutputStream outputStream = new FileOutputStream(file);
            this._persistentLayouts.store(outputStream, "");
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Writing properties failed" + String.valueOf(e) + "\n"));
        }
    }

    private void loadInitialButtonLayouts() {
        try {
            this._persistentLayouts = new Properties();
            File file = new File(PluginManager.getPreferencesLocation(), "renewButtonLayout.properties");
            if (!file.exists()) {
                file.createNewFile();
            } else {
                try (FileInputStream stream = new FileInputStream(file);){
                    this._persistentLayouts.load(stream);
                }
            }
            List<StorableButtonContainerLayout> layouts = StorableButtonContainerLayout.createLayoutsFromProperties(this._persistentLayouts);
            this._semaphore.acquire();
            for (StorableButtonContainerLayout layout : layouts) {
                this._unavailableLayouts.put(layout._layoutName, layout);
            }
            this._semaphore.release();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error((Object)("Loading button layouts failed" + String.valueOf(e) + "\n"));
        }
    }

    private void initComboBox() {
        this._chooseToolsComboBox.addActionListener(e -> {
            JComboBox cb = (JComboBox)e.getSource();
            String id = (String)cb.getSelectedItem();
            this.reAddTools(id);
        });
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index > -1 && value != null && ToolButtonScrollPane.this._tooltips != null) {
                    String key = ToolButtonScrollPane.this._chooseToolsComboBox.getItemAt(index);
                    String tooltip = ToolButtonScrollPane.this._tooltips.get(key);
                    list.setToolTipText(tooltip);
                }
                return comp;
            }
        };
        this._chooseToolsComboBox.setRenderer(renderer);
    }

    private JPanel createLayoutPanel() {
        JTextField textField = new JTextField();
        textField.setEditable(true);
        ToolButtonScrollPane handle = this;
        JButton saveButton = new JButton();
        ImageIcon icon = new ImageIcon(this.loadImage("CH/ifa/draw/images/buttonlayout_save.png"));
        saveButton.setIcon(icon);
        saveButton.setToolTipText("Saves the current layout under the specified name.");
        saveButton.addActionListener(e -> {
            String name;
            switch (name = textField.getText()) {
                case "": {
                    textField.setText("Enter name");
                }
                case "Enter name": {
                    break;
                }
                default: {
                    handle.saveLayout(name);
                }
            }
        });
        JButton loadButton = new JButton();
        icon = new ImageIcon(this.loadImage("CH/ifa/draw/images/buttonlayout_load.png"));
        loadButton.setIcon(icon);
        loadButton.setToolTipText("Loads the selected Layout.");
        loadButton.addActionListener(e -> {
            StorableButtonContainerLayout layout = (StorableButtonContainerLayout)this._chooseLayoutBox.getSelectedItem();
            if (layout != null) {
                this.loadLayout(layout);
            }
        });
        JButton deleteButton = new JButton();
        icon = new ImageIcon(this.loadImage("CH/ifa/draw/images/buttonlayout_delete.png"));
        deleteButton.setIcon(icon);
        deleteButton.addActionListener(e -> {
            StorableButtonContainerLayout layout = (StorableButtonContainerLayout)this._chooseLayoutBox.getSelectedItem();
            if (layout != null) {
                this._chooseLayoutBox.removeItem(layout);
                this._persistentLayouts.remove(layout._layoutName);
            }
        });
        this._chooseLayoutBox = new JComboBox<StorableButtonContainerLayout>(){

            @Override
            public void removeItem(Object item) {
                super.removeItem(item);
                if (this.getItemCount() == 0) {
                    this.setVisible(false);
                }
            }

            @Override
            public void addItem(StorableButtonContainerLayout item) {
                int count = this.getItemCount();
                for (int i = 0; i < count; ++i) {
                    StorableButtonContainerLayout duplicate = (StorableButtonContainerLayout)this.getItemAt(i);
                    if (duplicate == null || !duplicate.equals(item)) continue;
                    this.removeItemAt(i);
                }
                super.addItem(item);
                this.setVisible(true);
                this.revalidate();
            }
        };
        this._chooseLayoutBox.setVisible(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel label = new JLabel("Panel Layout");
        label.setHorizontalAlignment(0);
        label.setAlignmentX(0.5f);
        panel.add(label);
        panel.add(textField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 2));
        buttonPanel.add(saveButton);
        buttonPanel.add(loadButton);
        buttonPanel.add(deleteButton);
        panel.add(buttonPanel);
        panel.add(this._chooseLayoutBox);
        panel.setBorder(BorderFactory.createLoweredSoftBevelBorder());
        return panel;
    }

    @Override
    public void addTools(Set<AbstractButton> buttons, String id) {
        this.addTools(buttons, id, id);
    }

    @Override
    public void addTools(Set<AbstractButton> buttons, String id, String description) {
        try {
            this._semaphore.acquire();
            for (AbstractButton button : buttons) {
                DraggableComponentAdapter adapter = new DraggableComponentAdapter((DragCanvas)this, (Component)button);
                button.addMouseListener((MouseListener)adapter);
                button.addMouseMotionListener((MouseMotionListener)adapter);
                this._groupingLookup.put(button.getName(), id);
                this._buttonLookup.put(button.getName(), button);
            }
            this._registeredButtons.put(id, buttons);
            this._tooltips.put(id, description);
            this._chooseToolsComboBox.addItem(id);
            HashSet<StorableButtonContainerLayout> layouts = new HashSet<StorableButtonContainerLayout>(this._unavailableLayouts.values());
            for (StorableButtonContainerLayout layout : layouts) {
                if (!layout.isAvailable(this._registeredButtons.keySet())) continue;
                this._chooseLayoutBox.addItem(layout);
                this._unavailableLayouts.remove(layout._layoutName);
            }
            this.createToolButtonContainer(buttons);
            this._semaphore.release();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Add tools failed" + String.valueOf(e) + "\n"));
        }
    }

    private void reAddTools(String id) {
        Set<AbstractButton> buttons = this._registeredButtons.get(id);
        if (buttons != null) {
            this.createToolButtonContainer(buttons);
        }
    }

    @Override
    public void removeTools(String id) {
        try {
            this._semaphore.acquire();
            Set<AbstractButton> buttons = this._registeredButtons.remove(id);
            this._chooseToolsComboBox.removeItem(id);
            this._tooltips.remove(id);
            if (buttons != null) {
                JPanel tempPanel = new JPanel();
                for (AbstractButton button : buttons) {
                    tempPanel.add(button);
                    this._groupingLookup.remove(button.getName());
                    this._buttonLookup.remove(button.getName());
                }
                int count = this._chooseLayoutBox.getItemCount();
                for (int i = 0; i < count; ++i) {
                    StorableButtonContainerLayout layout = this._chooseLayoutBox.getItemAt(i);
                    if (layout.isAvailable(this._registeredButtons.keySet())) continue;
                    this._unavailableLayouts.put(layout._layoutName, layout);
                }
                for (StorableButtonContainerLayout value : this._unavailableLayouts.values()) {
                    this._chooseLayoutBox.removeItem(value);
                }
                this.revalidate();
            }
            this._semaphore.release();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Remove tools failed" + String.valueOf(e) + "\n"));
        }
    }

    private void createToolButtonContainer(Set<AbstractButton> buttons) {
        ToolButtonContainer container = new ToolButtonContainer(buttons);
        DraggableComponentAdapter adapter = new DraggableComponentAdapter((DragCanvas)this, (Component)container);
        container.addMouseListener((MouseListener)adapter);
        container.addMouseMotionListener((MouseMotionListener)adapter);
        int count = this._content.getComponentCount();
        this._content.add((Component)container, count - 1);
        this.revalidate();
    }

    public void dropComponent(Component draggedComponent, Point locationOnScreen) {
        if (this._content.isVisible()) {
            this._content.dropComponent(draggedComponent, locationOnScreen);
        }
    }

    public void saveLayout(String layoutName) {
        try {
            this._semaphore.acquire();
            StorableButtonContainerLayout layout = StorableButtonContainerLayout.createLayout(this._content.getComponents(), this._groupingLookup, layoutName);
            this._chooseLayoutBox.addItem(layout);
            this._unavailableLayouts.remove(layoutName);
            this._semaphore.release();
            new Thread(() -> StorableButtonContainerLayout.writeToProperties(this._persistentLayouts, layout)).start();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Saving layout failed" + String.valueOf(e) + "\n"));
        }
    }

    private void loadLayout(StorableButtonContainerLayout layout) {
        try {
            this._semaphore.acquire();
            List<Set<AbstractButton>> buttons = StorableButtonContainerLayout.readLayout(layout, this._buttonLookup);
            this._content.removeAllToolButtonContainers();
            for (Set<AbstractButton> set : buttons) {
                this.createToolButtonContainer(set);
            }
            this._semaphore.release();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Loading layout failed" + String.valueOf(e) + "\n"));
        }
    }

    private BufferedImage loadImage(String path) {
        URL url = PluginManager.getInstance().getBottomClassLoader().getResource(path);
        if (url == null) {
            File file = new File(path);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Loading image failed" + String.valueOf(e) + "\n"));
            }
        }
        if (url != null) {
            try {
                return ImageIO.read(url);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Loading image failed" + String.valueOf(e) + "\n"));
            }
        }
        return null;
    }

    private class CreateNewContainerTarget
    extends JPanel
    implements DraggableComponentDropTarget {
        CreateNewContainerTarget() {
            final JLabel handle = new JLabel("<html>Mouse over</html>");
            handle.setHorizontalAlignment(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    handle.setText("<html>Drop Button here to create new Container</html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    handle.setText("<html>Mouse over</html>");
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)handle, "Center");
            this.setBorder(BorderFactory.createLoweredSoftBevelBorder());
        }

        public void dropComponent(Component draggedComponent, Point locationOnScreen) {
            if (draggedComponent instanceof AbstractButton) {
                HashSet<AbstractButton> set = new HashSet<AbstractButton>();
                set.add((AbstractButton)draggedComponent);
                ToolButtonScrollPane.this.createToolButtonContainer(set);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color background = DockUI.getColor((String)"dock.title.selection.background");
            Color brighter = DockUI.getColor((String)"dock.title.background");
            Graphics2D g2 = (Graphics2D)g;
            GradientPaint backgroundPaint = new GradientPaint(0.0f, 0.0f, background, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, brighter, true);
            g2.setPaint(backgroundPaint);
            g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }
}

