/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.SnapshotHistory;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UndoRedoManager {
    private static final int UNDOSTEPS = 20;
    private static final int ACCUMULATIONTIME = 800;
    private final Hashtable<Drawing, SnapshotHistory> _undoHistoryTable = new Hashtable();
    private final Hashtable<Drawing, SnapshotHistory> _redoHistoryTable = new Hashtable();
    private final DrawingEditor _editor;
    private final Hashtable<Drawing, ScheduledFuture<?>> _accumulationCommitFutures = new Hashtable();
    private final ScheduledExecutorService _scheduledThreadPool;
    private static final Logger LOGGER = Logger.getLogger(UndoRedoManager.class);

    public UndoRedoManager(DrawingEditor editor) {
        this._editor = editor;
        this._scheduledThreadPool = Executors.newScheduledThreadPool(0);
    }

    public void prepareUndoSnapshot(Drawing drawing) {
        this.commitPendingAccumulatedUndoSnapshot(drawing);
        SnapshotHistory undoHistory = this.getUndoHistory(drawing);
        if (undoHistory != null) {
            undoHistory.prepareSnapshot();
        }
    }

    public void commitUndoSnapshot(Drawing drawing) {
        SnapshotHistory undoHistory = this.getUndoHistory(drawing);
        SnapshotHistory redoHistory = this.getRedoHistory(drawing);
        if (undoHistory != null) {
            undoHistory.commitSnapshot();
            redoHistory.clear();
            this._editor.menuStateChanged();
        }
    }

    public void restoreUndoSnapshot(Drawing drawing) {
        SnapshotHistory undoHistory = this.getUndoHistory(drawing);
        SnapshotHistory redoHistory = this.getRedoHistory(drawing);
        this.commitPendingAccumulatedUndoSnapshot(drawing);
        if (!undoHistory.isEmpty()) {
            redoHistory.takeSnapshot();
            undoHistory.restoreSnapshot();
            this._editor.showStatus("Undone.");
        } else {
            this._editor.showStatus("Nothing to undo.");
        }
    }

    public void restoreRedoSnapshot(Drawing drawing) {
        SnapshotHistory undoHistory = this.getUndoHistory(drawing);
        SnapshotHistory redoHistory = this.getRedoHistory(drawing);
        this.commitPendingAccumulatedUndoSnapshot(drawing);
        if (redoHistory != null) {
            if (!redoHistory.isEmpty()) {
                undoHistory.takeSnapshot();
                redoHistory.restoreSnapshot();
                this._editor.showStatus("Redone.");
            } else {
                this._editor.showStatus("Nothing to redo.");
            }
        }
    }

    public SnapshotHistory getUndoHistory(Drawing drawing) {
        return this._undoHistoryTable.get(drawing);
    }

    public SnapshotHistory getRedoHistory(Drawing drawing) {
        return this._redoHistoryTable.get(drawing);
    }

    public void clearUndoHistory(Drawing drawing) {
        SnapshotHistory undoHistory = this._undoHistoryTable.get(drawing);
        SnapshotHistory redoHistory = this._redoHistoryTable.get(drawing);
        if (undoHistory != null) {
            undoHistory.clear();
            redoHistory.clear();
            this._editor.menuStateChanged();
        }
        this.cancelPendingAccumulatedUndoSnapshot(drawing);
    }

    public void newUndoHistory(Drawing drawing) {
        SnapshotHistory undoHistory = this._undoHistoryTable.get(drawing);
        if (undoHistory == null) {
            this._undoHistoryTable.put(drawing, new SnapshotHistory(drawing, 20));
            this._redoHistoryTable.put(drawing, new SnapshotHistory(drawing, 20));
        }
    }

    public void removeUndoHistory(Drawing drawing) {
        this._undoHistoryTable.remove(drawing);
        this._redoHistoryTable.remove(drawing);
        this.cancelPendingAccumulatedUndoSnapshot(drawing);
        this._editor.menuStateChanged();
    }

    private void cancelPendingAccumulatedUndoSnapshot(Drawing drawing) {
        if (this._accumulationCommitFutures.containsKey(drawing)) {
            ScheduledFuture<?> future = this._accumulationCommitFutures.remove(drawing);
            future.cancel(true);
        }
    }

    private boolean isAccumulatedUndoSnapshotPending(Drawing drawing) {
        ScheduledFuture<?> future;
        boolean result = false;
        if (this._accumulationCommitFutures.containsKey(drawing) && !(future = this._accumulationCommitFutures.get(drawing)).isCancelled() && !future.isDone()) {
            result = true;
        }
        return result;
    }

    private void commitPendingAccumulatedUndoSnapshot(Drawing drawing) {
        if (this.isAccumulatedUndoSnapshotPending(drawing)) {
            this.cancelPendingAccumulatedUndoSnapshot(drawing);
            this.commitUndoSnapshot(drawing);
        }
    }

    public void prepareAccumulatedUndoSnapshot(Drawing drawing) {
        SnapshotHistory undoHistory;
        if (!this.isAccumulatedUndoSnapshotPending(drawing) && (undoHistory = this.getUndoHistory(drawing)) != null) {
            undoHistory.prepareSnapshot();
        }
    }

    public void triggerAccumulatedUndoSnapshot(Drawing drawing) {
        this.cancelPendingAccumulatedUndoSnapshot(drawing);
        Runnable commitSnapshotTask = () -> {
            this.commitUndoSnapshot(drawing);
            LOGGER.debug((Object)"Commiting accumulated snapshot.");
        };
        Runnable awtCommitSnapshotTask = () -> {
            try {
                EventQueue.invokeAndWait(commitSnapshotTask);
            }
            catch (InvocationTargetException ite) {
                Throwable targetException = ite.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug((Object)"Scheduled accumulated snapshot task was canceled.");
            }
        };
        ScheduledFuture<?> future = this._scheduledThreadPool.schedule(awtCommitSnapshotTask, 800L, TimeUnit.MILLISECONDS);
        this._accumulationCommitFutures.put(drawing, future);
    }
}

