/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Figure;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureSelection {
    public static final Logger LOGGER = Logger.getLogger(FigureSelection.class);
    public static final String TYPE = "CH.ifa.draw.Figures";
    private final byte[] _data;

    public FigureSelection(Vector<Figure> figures) {
        this._data = this.writeData(figures);
    }

    public FigureSelection(Enumeration<Figure> figures) {
        Vector<Figure> vector = new Vector<Figure>();
        while (figures.hasMoreElements()) {
            vector.addElement(figures.nextElement());
        }
        this._data = this.writeData(vector);
    }

    private byte[] writeData(Vector<Figure> vector) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream writer = new ObjectOutputStream(output);
            writer.writeInt(vector.size());
            Enumeration<Figure> figures = vector.elements();
            while (figures.hasMoreElements()) {
                Figure figure = figures.nextElement();
                writer.writeObject(figure);
            }
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Figure serialization failed: " + String.valueOf(e) + "\n"));
        }
        return output.toByteArray();
    }

    public String getType() {
        return TYPE;
    }

    public Vector<Figure> getData(String type) {
        if (type.equals(TYPE)) {
            ByteArrayInputStream input = new ByteArrayInputStream(this._data);
            Vector<Figure> result = new Vector<Figure>(10);
            try {
                ObjectInputStreamUsingBottomLoader reader = new ObjectInputStreamUsingBottomLoader((InputStream)input);
                int count = reader.readInt();
                for (int numRead = 0; numRead < count; ++numRead) {
                    Figure newFigure = (Figure)reader.readObject();
                    result.addElement(newFigure);
                }
                reader.close();
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error((Object)("Figure deserialization failed: " + String.valueOf(e)));
            }
            return result;
        }
        return null;
    }
}

