/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.InsertPointHandle;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineConnector;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.figures.PolyLineLocator;
import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.util.BSpline;
import CH.ifa.draw.util.DoublePoint;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.ClassSource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PolyLineFigure
extends AttributeFigure
implements PolyLineable {
    public static Logger logger = Logger.getLogger(PolyLineFigure.class);
    public static final int ARROW_TIP_NONE = 0;
    public static final int ARROW_TIP_START = 1;
    public static final int ARROW_TIP_END = 2;
    public static final int ARROW_TIP_BOTH = 3;
    public static final int LINE_SHAPE = 0;
    public static final int BSPLINE_SHAPE = 1;
    private static final long serialVersionUID = -7951352179906577773L;
    private static Integer BSPLINE_SHAPE_OBJ = 1;
    protected Vector<Point> fPoints;
    protected transient BSpline spline = null;
    protected LineDecoration fStartDecoration = null;
    protected LineDecoration fEndDecoration = null;
    protected Class<?> fArrowTipClass = ArrowTip.class;
    private int polyLineFigureSerializedDataVersion = 1;

    public PolyLineFigure() {
        this.fPoints = new Vector(4);
    }

    public PolyLineFigure(int size) {
        this.fPoints = new Vector(size);
    }

    public PolyLineFigure(int x, int y) {
        this.fPoints = new Vector();
        this.fPoints.addElement(new Point(x, y));
    }

    protected boolean drawAsSpline() {
        Object line_shape = this.getAttribute("LineShape");
        return BSPLINE_SHAPE_OBJ.equals(line_shape);
    }

    private Vector<Point> drawPointsVector() {
        if (this.drawAsSpline()) {
            if (this.spline == null) {
                this.updateSpline();
            }
            return this.spline.getCurvepointsInt();
        }
        return this.fPoints;
    }

    private Vector<DoublePoint> drawDoublePointsVector() {
        if (this.drawAsSpline()) {
            if (this.spline == null) {
                this.updateSpline();
            }
            return this.spline.getCurvepointsDouble();
        }
        return DoublePoint.convertPointVector(this.fPoints);
    }

    private void updateSpline() {
        Object spline_degree = this.getAttribute("BSplineDegree");
        Object spline_segments = this.getAttribute("BSplineSegments");
        this.spline = new BSpline(this.fPoints, (Integer)spline_segments, (Integer)spline_degree);
    }

    @Override
    public Rectangle displayBox() {
        Enumeration<Point> k = this.points();
        Rectangle r = new Rectangle(k.nextElement());
        while (k.hasMoreElements()) {
            r.add(k.nextElement());
        }
        return r;
    }

    @Override
    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    protected void addIntermediateHandles(Vector<Handle> handles) {
        int i;
        for (i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        for (i = 0; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new InsertPointHandle(this, i));
        }
    }

    @Override
    public Vector<Handle> handles() {
        int n = this.fPoints.size();
        Vector<Handle> handles = new Vector<Handle>(2 * n);
        handles.addElement(new PolyLineHandle(this, PolyLineFigure.locator(0), 0));
        this.addIntermediateHandles(handles);
        handles.addElement(new PolyLineHandle(this, PolyLineFigure.locator(n - 1), n - 1));
        return handles;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
    }

    public void addPoint(int x, int y) {
        this.fPoints.addElement(new Point(x, y));
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    public Enumeration<Point> points() {
        return this.fPoints.elements();
    }

    @Override
    public int pointCount() {
        return this.fPoints.size();
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        Enumeration<Point> k = this.fPoints.elements();
        while (k.hasMoreElements()) {
            k.nextElement().translate(dx, dy);
        }
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
    }

    @Override
    public void setPointAt(Point p, int i) {
        this.willChange();
        this.fPoints.setElementAt(p, i);
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    @Override
    public void insertPointAt(Point p, int i) {
        this.fPoints.insertElementAt(p, i);
        if (this.spline != null) {
            this.spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    @Override
    public void removePointAt(int i) {
        if (this.fPoints.size() > 2) {
            this.willChange();
            this.fPoints.removeElementAt(i);
            if (this.spline != null) {
                this.spline.setPoints(this.fPoints);
            }
            this.changed();
        }
    }

    public int splitSegment(int x, int y) {
        int i = this.findSegment(x, y);
        if (i != -1) {
            this.insertPointAt(new Point(x, y), i + 1);
        }
        return i + 1;
    }

    @Override
    public Point pointAt(int i) {
        return this.fPoints.elementAt(i);
    }

    public boolean joinSegments(int x, int y) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            Point p = this.pointAt(i);
            if (Geom.length(x, y, p.x, p.y) >= 3L) continue;
            this.removePointAt(i);
            return true;
        }
        return false;
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new PolyLineConnector(this);
    }

    public void setStartDecoration(LineDecoration l) {
        this.fStartDecoration = l;
    }

    protected void setStartDecoration() {
        try {
            this.setStartDecoration((LineDecoration)this.fArrowTipClass.newInstance());
        }
        catch (Exception e) {
            logger.error((Object)("Could not set arrow tip:\n" + String.valueOf(e)));
        }
    }

    public void setEndDecoration(LineDecoration l) {
        this.fEndDecoration = l;
    }

    public float distance() {
        Enumeration<Point> points = this.points();
        Point first = points.nextElement();
        float distance = 0.0f;
        while (points.hasMoreElements()) {
            Point second = points.nextElement();
            distance = (float)((double)distance + first.distance(second));
            first = second;
        }
        return distance;
    }

    protected void setEndDecoration() {
        try {
            this.setEndDecoration((LineDecoration)this.fArrowTipClass.newInstance());
        }
        catch (Exception e) {
            logger.error((Object)("Could not set arrow tip:\n" + String.valueOf(e)));
        }
    }

    @Override
    public void drawFrame(Graphics g) {
        int i;
        Vector<DoublePoint> drawPoints = this.drawDoublePointsVector();
        int size = drawPoints.size();
        double[] xPoints = new double[size];
        double[] yPoints = new double[size];
        for (int i2 = 0; i2 < size; ++i2) {
            DoublePoint p = drawPoints.elementAt(i2);
            xPoints[i2] = p.x;
            yPoints[i2] = p.y;
        }
        GeneralPath shape = new GeneralPath();
        shape.moveTo((float)xPoints[i], (float)yPoints[i]);
        for (i = 0; i < size; ++i) {
            shape.lineTo((float)xPoints[i], (float)yPoints[i]);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Integer width = (Integer)this.getAttribute("LineWidth");
        BasicStroke str = (BasicStroke)g2.getStroke();
        if (width != null) {
            BasicStroke s = new BasicStroke(width.intValue(), str.getEndCap(), str.getLineJoin(), str.getMiterLimit(), str.getDashArray(), str.getDashPhase());
            g2.setStroke(s);
        }
        g2.draw(shape);
        if (width == null) {
            g2.setStroke(new BasicStroke());
        } else {
            g2.setStroke(new BasicStroke(width.intValue()));
        }
        this.decorate(g);
        g2.setStroke(str);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        Rectangle bounds = this.displayBox();
        bounds.grow(4, 4);
        if (!bounds.contains(x, y)) {
            return false;
        }
        Vector<Point> drawPoints = this.drawPointsVector();
        for (int i = 0; i < drawPoints.size() - 1; ++i) {
            Point p1 = drawPoints.elementAt(i);
            Point p2 = drawPoints.elementAt(i + 1);
            if (!Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) continue;
            return true;
        }
        return false;
    }

    private int lineSegment(int i) {
        if (this.drawAsSpline()) {
            return this.spline.lineSegment(i);
        }
        return i;
    }

    public int findSegment(int x, int y) {
        Vector<Point> drawPoints = this.drawPointsVector();
        for (int i = 0; i < drawPoints.size() - 1; ++i) {
            Point p1 = drawPoints.elementAt(i);
            Point p2 = drawPoints.elementAt(i + 1);
            if (!Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) continue;
            return this.lineSegment(i);
        }
        return -1;
    }

    private void decorate(Graphics g) {
        if (this.fStartDecoration != null) {
            Point p1 = this.fPoints.elementAt(0);
            Point p2 = this.fPoints.elementAt(1);
            this.fStartDecoration.draw(g, p1.x, p1.y, p2.x, p2.y, this.getFillColor(), this.getFrameColor());
        }
        if (this.fEndDecoration != null) {
            Point p3 = this.fPoints.elementAt(this.fPoints.size() - 2);
            Point p4 = this.fPoints.elementAt(this.fPoints.size() - 1);
            this.fEndDecoration.draw(g, p4.x, p4.y, p3.x, p3.y, this.getFillColor(), this.getFrameColor());
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("ArrowMode")) {
            int value = 0;
            if (this.fStartDecoration != null) {
                value |= 1;
            }
            if (this.fEndDecoration != null) {
                value |= 2;
            }
            return value;
        }
        if (name.equals("ArrowTip")) {
            return this.fArrowTipClass.getName();
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("ArrowMode")) {
            Integer intObj = (Integer)value;
            if (intObj != null) {
                int decoration = intObj;
                if ((decoration & 1) != 0) {
                    this.setStartDecoration();
                } else {
                    this.setStartDecoration(null);
                }
                if ((decoration & 2) != 0) {
                    this.setEndDecoration();
                } else {
                    this.setEndDecoration(null);
                }
            }
        } else if (name.equals("ArrowTip")) {
            String decorationClass = (String)value;
            try {
                this.fArrowTipClass = ClassSource.classForName((String)decorationClass);
                if (this.fStartDecoration != null) {
                    this.setStartDecoration();
                }
                if (this.fEndDecoration != null) {
                    this.setEndDecoration();
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("Trying to use " + decorationClass + " for arrow tips:\n" + String.valueOf(e)));
            }
        } else if (name.equals("LineStyle")) {
            String lineStyle = (String)value;
            if (value != null) {
                super.setAttribute("LineStyle", lineStyle);
            }
        } else {
            if (this.spline != null) {
                if (name.equals("BSplineDegree")) {
                    int degree = (Integer)value;
                    this.spline.setDegree(degree);
                } else if (name.equals("BSplineSegments")) {
                    int segments = (Integer)value;
                    this.spline.setSegments(segments);
                }
            }
            super.setAttribute(name, value);
        }
        this.changed();
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fPoints.size());
        Enumeration<Point> k = this.fPoints.elements();
        while (k.hasMoreElements()) {
            Point p = k.nextElement();
            dw.writeInt(p.x);
            dw.writeInt(p.y);
        }
        dw.writeStorable(this.fStartDecoration);
        dw.writeStorable(this.fEndDecoration);
        dw.writeString(this.fArrowTipClass.getName());
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        if (dr.getVersion() >= 1) {
            super.read(dr);
        }
        int size = dr.readInt();
        this.fPoints = new Vector(size);
        for (int i = 0; i < size; ++i) {
            int x = dr.readInt();
            int y = dr.readInt();
            this.fPoints.addElement(new Point(x, y));
        }
        this.fStartDecoration = (LineDecoration)dr.readStorable();
        this.fEndDecoration = (LineDecoration)dr.readStorable();
        if (dr.getVersion() >= 8) {
            String arrowName = dr.readString();
            this.setAttribute("ArrowTip", arrowName);
        }
        if (dr.getVersion() == 0) {
            Color color = dr.readColor();
            this.setAttribute("FrameColor", color);
        }
    }

    public static Locator locator(int pointIndex) {
        return new PolyLineLocator(pointIndex);
    }
}

