/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.io.ImageFileFilter;
import CH.ifa.draw.standard.CreationTool;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ImageFigureCreationTool
extends CreationTool
implements ImageObserver {
    public static Logger logger = Logger.getLogger(ImageFigureCreationTool.class);
    private Image image;
    private String fImageName = null;
    private JFrame frame;

    public ImageFigureCreationTool(DrawingEditor editor, JFrame frame) {
        super(editor);
        this.frame = frame;
    }

    private String showFileDialog() {
        IOHelper iohelper = DrawPlugin.getCurrent().getIOHelper();
        JFileChooser fc = new JFileChooser(iohelper.getLastPath());
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new ImageFileFilter());
        fc.setFileHidingEnabled(true);
        fc.setMultiSelectionEnabled(false);
        int returnVal = fc.showOpenDialog(null);
        if (returnVal != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        iohelper.setLastPath(file);
        return file.getAbsolutePath();
    }

    public static Image createImage(String fileName, Component frame) {
        Image image = Toolkit.getDefaultToolkit().getImage(fileName);
        if (image != null) {
            MediaTracker tracker = new MediaTracker(frame);
            tracker.addImage(image, 123);
            try {
                tracker.waitForAll();
            }
            catch (Exception e) {
                image = null;
            }
        }
        return image;
    }

    @Override
    public void activate() {
        super.activate();
        this.image = null;
        this.fImageName = this.showFileDialog();
        if (this.fImageName != null) {
            this.image = ImageFigureCreationTool.createImage(this.fImageName, this.frame);
            if (this.image == null) {
                this.noChangesMade();
                this.fEditor.toolDone();
                this.fEditor.showStatus("Image " + this.fImageName + " could not be loaded!");
            }
        } else {
            this.noChangesMade();
            this.fEditor.setStickyTools(false);
            this.fEditor.toolDone();
            this.fEditor.showStatus("Image creation canceled.");
        }
    }

    @Override
    protected Figure createFigure() {
        if (this.fImageName != null && this.image != null) {
            Point pnt = this.fEditor.view().lastClick();
            ImageFigure imageFigure = new ImageFigure(this.image, this.fImageName, pnt);
            Rectangle displayBox = imageFigure.displayBox();
            imageFigure.moveBy(-(displayBox.width / 2), -(displayBox.height / 2));
            return imageFigure;
        }
        return null;
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        Figure created = this.createdFigure();
        if (created != null && created.isEmpty()) {
            Point loc = created.displayBox().getLocation();
            int width = this.image.getWidth(this);
            int height = this.image.getHeight(this);
            if (width == -1 || height == -1) {
                logger.error((Object)"Image not loaded properly!");
            } else {
                created.displayBox(loc, new Point(loc.x + width, loc.y + height));
            }
        }
        super.mouseUp(e, x, y);
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

