/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.plugin.BottomClassLoader;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.log4j.Logger;

public class ObjectInputStreamUsingBottomLoader
extends ObjectInputStream {
    public static Logger logger = Logger.getLogger(ObjectInputStreamUsingBottomLoader.class);

    public ObjectInputStreamUsingBottomLoader(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), true, PluginManager.getInstance().getBottomClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)("Using ObjectInputStream's default class loader to resolve " + desc.getName() + "."));
            logger.warn((Object)("Please make sure the class you are trying to load is known to the class loader of a module, the " + PluginClassLoader.class.getSimpleName() + ", orthe " + BottomClassLoader.class.getSimpleName() + "."));
            return super.resolveClass(desc);
        }
    }
}

