/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PrimaryPart;
import de.renew.formalism.java.Suggestion;
import de.renew.formalism.java.TypedExpression;
import de.renew.unify.List;
import de.renew.unify.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

public class VariableSuggestion
extends Suggestion {
    private final Class<?> _type;
    private final boolean _importNeeded;
    private boolean _editDesired = false;

    public static Collection<VariableSuggestion> suggest(PrimaryPart firstPart, TypedExpression right, ParsedDeclarationNode declarationNode) {
        String variableName = (String)firstPart.obj;
        ArrayList variableTypes = new ArrayList();
        Class<?> rightType = VariableSuggestion.suggestByRightExpression(right);
        if (rightType != null) {
            variableTypes.add(rightType);
        }
        variableTypes.addAll(VariableSuggestion.suggestImported(variableName.charAt(0), declarationNode.getWellKnownClasses()));
        variableTypes.addAll(VariableSuggestion.suggestPrimitives(variableName.charAt(0)));
        variableTypes.addAll(VariableSuggestion.suggestStatic());
        LinkedHashSet<VariableSuggestion> result = new LinkedHashSet<VariableSuggestion>();
        boolean objectEditOnce = true;
        for (Class clazz : variableTypes) {
            boolean importNeeded = false;
            if (clazz.getPackage() != null && declarationNode.interpreteName(clazz.getSimpleName()) == null) {
                importNeeded = true;
            }
            VariableSuggestion sug = new VariableSuggestion(variableName, clazz, importNeeded);
            if (clazz == Object.class && objectEditOnce) {
                sug._editDesired = true;
                objectEditOnce = false;
            }
            result.add(sug);
        }
        return result;
    }

    private static Class<?> suggestByRightExpression(TypedExpression rightExp) {
        if (rightExp != null && rightExp.getType() != null) {
            return rightExp.getType();
        }
        return null;
    }

    private static Collection<Class<?>> suggestPrimitives(char variableNameFirstChar) {
        ArrayList variableTypes = new ArrayList();
        char upperFirstChar = Character.toUpperCase(variableNameFirstChar);
        for (Class primitive : Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class)) {
            if (primitive.getSimpleName().charAt(0) != upperFirstChar) continue;
            variableTypes.add(primitive);
        }
        return variableTypes;
    }

    private static Collection<Class<?>> suggestImported(char variableNameFirstChar, Map<String, Class<?>> knownClasses) {
        ArrayList variableTypes = new ArrayList();
        char upperFirstChar = Character.toUpperCase(variableNameFirstChar);
        for (String simpleName : knownClasses.keySet()) {
            if (simpleName.charAt(0) != upperFirstChar) continue;
            variableTypes.add(knownClasses.get(simpleName));
        }
        return variableTypes;
    }

    private static Collection<Class<?>> suggestStatic() {
        ArrayList suggestions = new ArrayList();
        suggestions.add(List.class);
        suggestions.add(Tuple.class);
        suggestions.add(Object.class);
        suggestions.add(Object.class);
        return suggestions;
    }

    public VariableSuggestion(String name, Class<?> type, boolean importNeeded) {
        super(name, VariableSuggestion.unboxPrimitive(type));
        this._type = type;
        this._importNeeded = importNeeded;
    }

    public boolean isImportNeeded() {
        return this._importNeeded;
    }

    public Class<?> getType() {
        return this._type;
    }

    public boolean isEditDesired() {
        return this._editDesired;
    }

    @Override
    public String toString() {
        String pack = this._type.getPackage() == null ? "" : this._type.getPackage().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>Declare ");
        sb.append(this.getName());
        sb.append(" as ");
        sb.append(this.getTypeName());
        if (this._editDesired) {
            sb.append(" and edit");
        }
        sb.append(" <font color=gray>- ");
        sb.append(pack);
        sb.append("</font></html>");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VariableSuggestion other = (VariableSuggestion)obj;
        return this._type.equals(other._type) && this._editDesired == other._editDesired;
    }

    public int hashCode() {
        return this._type.hashCode() + (this._editDesired ? 0 : 1);
    }

    private static String unboxPrimitive(Class<?> clazz) {
        if (clazz == Byte.class) {
            return "byte";
        }
        if (clazz == Short.class) {
            return "short";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.class) {
            return "double";
        }
        if (clazz == Boolean.class) {
            return "boolean";
        }
        if (clazz == Character.class) {
            return "char";
        }
        return clazz.getSimpleName();
    }
}

