/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.function.CastFunction;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.FlexibleArc;
import de.renew.shadow.SyntaxException;
import de.renew.unify.List;
import de.renew.util.Types;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class FlexibleOutArcFactory
implements ArcFactory {
    public static FlexibleOutArcFactory _instance = new FlexibleOutArcFactory();

    private FlexibleOutArcFactory() {
    }

    @Override
    public void emptyArcCheck() throws SyntaxException {
        throw new SyntaxException("Flexible arcs must be inscribed.");
    }

    @Override
    public boolean allowsTime() {
        return true;
    }

    @Override
    public void compileArc(Place place, Transition transition, boolean trace, Class<?> placeType, ArcInscription insc) throws SyntaxException {
        TypedExpression typedExpr = insc.getExpression();
        CastFunction conversionFunction = null;
        Class<?> exprType = typedExpr.getType();
        if (exprType != Types.UNTYPED) {
            if (exprType == null) {
                throw new SyntaxException("Null not allowed for flexible arcs.");
            }
            if (List.class.isAssignableFrom(exprType) || Enumeration.class.isAssignableFrom(exprType) || Iterator.class.isAssignableFrom(exprType) || Collection.class.isAssignableFrom(exprType)) {
                if (placeType != Types.UNTYPED) {
                    throw new SyntaxException("For non-array inscriptions the place must be untyped.");
                }
            } else if (!exprType.isArray()) {
                throw new SyntaxException("Incorrect type for flexible arc inscription.");
            }
        }
        if (placeType != Types.UNTYPED) {
            if (!typedExpr.isTyped()) {
                throw new SyntaxException("Output arc expression for typed place must be typed.");
            }
            Class<?> elementType = exprType.getComponentType();
            if (!Types.allowsLosslessWidening(elementType, placeType)) {
                throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(elementType) + " to " + JavaHelper.makeTypeErrorString(placeType) + ".");
            }
            if (placeType.isPrimitive()) {
                conversionFunction = new CastFunction(placeType);
            }
        }
        FlexibleArc arc = new FlexibleArc(place, transition, 1, typedExpr.getExpression(), conversionFunction, null);
        arc.setTrace(trace);
        transition.add((TransitionInscription)arc);
    }
}

