/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.unify.Tuple;
import de.renew.util.ClassSource;
import de.renew.util.Types;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class Executor {
    private static final Logger LOGGER = Logger.getLogger(Executor.class);
    public static final Object VOIDRETURN = new Object();
    private static Method _classForNameMethod;

    private Executor() {
    }

    public static Class<?>[] getTypes(Object[] params) {
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            parameterTypes[i] = params[i] instanceof Value ? Types.typify(((Value)params[i]).value.getClass()) : params[i].getClass();
        }
        return parameterTypes;
    }

    public static Constructor<?> findBestConstructor(Class<?> clazz, Class<?>[] params, boolean unique) throws NoSuchMethodException {
        try {
            return clazz.getConstructor(Executor.getTypes(params));
        }
        catch (Exception exception) {
            Class[] currentParams;
            Constructor<?>[] constructors = clazz.getConstructors();
            Constructor<?> best = null;
            Class[] bestParams = null;
            for (Constructor<?> constructor : constructors) {
                currentParams = constructor.getParameterTypes();
                if (!Types.allowsWideningConversion((Class[])params, (Class[])currentParams) || best != null && !Types.allowsWideningConversion((Class[])currentParams, bestParams)) continue;
                best = constructor;
                bestParams = currentParams;
            }
            if (best == null) {
                throw new NoSuchMethodException();
            }
            if (unique) {
                for (Constructor<?> constructor : constructors) {
                    currentParams = constructor.getParameterTypes();
                    if (!Types.allowsWideningConversion((Class[])params, (Class[])currentParams) || Types.allowsWideningConversion((Class[])bestParams, (Class[])currentParams)) continue;
                    return null;
                }
            }
            return best;
        }
    }

    private static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    private static Collection<Class<?>> findPublicSuperClasses(Class<?> clazz) {
        Class<?>[] interfaces;
        if (Executor.isPublic(clazz)) {
            Vector coll = new Vector();
            coll.add(clazz);
            return coll;
        }
        HashSet classes = new HashSet();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            classes.addAll(Executor.findPublicSuperClasses(superclass));
        }
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            classes.addAll(Executor.findPublicSuperClasses(anInterface));
        }
        return classes;
    }

    private static Tuple makeSignatureTuple(Class<?>[] params) {
        return new Tuple((Object[])params, null);
    }

    private static Method[] getPublicMethods(Class<?> clazz, String name, int paramCount) {
        Hashtable<Tuple, Method> map = new Hashtable<Tuple, Method>();
        for (Class<?> publicClass : Executor.findPublicSuperClasses(clazz)) {
            Method[] methods;
            for (Method method : methods = publicClass.getMethods()) {
                Class<?>[] params = method.getParameterTypes();
                if (!name.equals(method.getName()) || paramCount != params.length) continue;
                map.put(Executor.makeSignatureTuple(params), method);
            }
        }
        Method[] uniqueMethods = new Method[map.size()];
        Enumeration enumeration = map.elements();
        for (int i = 0; i < uniqueMethods.length; ++i) {
            uniqueMethods[i] = (Method)enumeration.nextElement();
        }
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Method count changed. Strange.");
        }
        return uniqueMethods;
    }

    public static Method findBestMethod(Class<?> clazz, String name, Class<?>[] params, boolean unique) throws NoSuchMethodException {
        Class[] currentParams;
        try {
            if (Executor.isPublic(clazz)) {
                return clazz.getMethod(name, Executor.getTypes(params));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Method[] methods = Executor.getPublicMethods(clazz, name, params.length);
        if (clazz.isInterface()) {
            Method[] interfaceMethods = methods;
            Method[] objectMethods = Object.class.getMethods();
            methods = new Method[interfaceMethods.length + objectMethods.length];
            System.arraycopy(interfaceMethods, 0, methods, 0, interfaceMethods.length);
            System.arraycopy(objectMethods, 0, methods, interfaceMethods.length, objectMethods.length);
        }
        Method best = null;
        Class[] bestParams = null;
        for (Method value : methods) {
            if (!name.equals(value.getName()) || !Types.allowsWideningConversion((Class[])params, (Class[])(currentParams = value.getParameterTypes())) || best != null && !Types.allowsWideningConversion((Class[])currentParams, bestParams)) continue;
            best = value;
            bestParams = currentParams;
        }
        if (best == null) {
            throw new NoSuchMethodException();
        }
        if (unique) {
            for (Method method : methods) {
                if (!name.equals(method.getName()) || !Types.allowsWideningConversion((Class[])params, (Class[])(currentParams = method.getParameterTypes())) || Types.allowsWideningConversion((Class[])bestParams, (Class[])currentParams)) continue;
                return null;
            }
        }
        return best;
    }

    public static Object executeConstructor(Constructor<?> constructor, Object[] params) throws NoSuchMethodException, InvocationTargetException {
        Object result;
        try {
            Object[] castedParams = Value.unvalueAndCast((Object[])params, (Class[])constructor.getParameterTypes());
            result = constructor.newInstance(castedParams);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("IllegalArgumentException in Executor!");
        }
        catch (InstantiationException ex) {
            throw new NoSuchMethodException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new NoSuchMethodException(ex.toString());
        }
        return result;
    }

    public static Object executeConstructor(Class<?> clazz, Object[] params) throws NoSuchMethodException, InvocationTargetException, LinkageError {
        if (clazz.isArray()) {
            Class<?> originalClass = clazz;
            int[] dimensions = new int[params.length];
            try {
                for (int i = 0; i < params.length; ++i) {
                    dimensions[i] = (Integer)Value.unvalueAndCast((Object)params[i], Integer.TYPE);
                    clazz = clazz.getComponentType();
                }
                if (clazz == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new NoSuchMethodException("Bad array constructor: " + Executor.renderArrayConstructor(originalClass, params));
            }
            return Array.newInstance(clazz, dimensions);
        }
        Constructor<?> constructor = Executor.findBestConstructor(clazz, Executor.getTypes(params), false);
        return Executor.executeConstructor(constructor, params);
    }

    public static Object executeMethod(Method method, Object target, Object[] params) throws NoSuchMethodException, InvocationTargetException {
        Object result;
        if (method.equals(_classForNameMethod) && params.length == 1 && params[0] instanceof String) {
            try {
                return ClassSource.classForName((String)((String)params[0]));
            }
            catch (Throwable t) {
                throw new InvocationTargetException(t);
            }
        }
        try {
            Object[] castedParams = Value.unvalueAndCast((Object[])params, (Class[])method.getParameterTypes());
            result = method.invoke(target, castedParams);
            result = method.getReturnType() == Void.TYPE ? VOIDRETURN : Value.possiblyWrap((Object)result, (boolean)method.getReturnType().isPrimitive());
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("IllegalArgumentException in Executor!");
        }
        catch (IllegalAccessException ex) {
            throw new NoSuchMethodException(ex.toString());
        }
        return result;
    }

    public static Object executeMethod(Class<?> clazz, Object target, String name, Object[] params) throws NoSuchMethodException, InvocationTargetException, LinkageError {
        Method method = Executor.findBestMethod(clazz, name, Executor.getTypes(params), false);
        return Executor.executeMethod(method, target, params);
    }

    public static String renderMethodSignature(Class<?> clazz, String name, Class<?>[] params) {
        StringBuilder signature = new StringBuilder();
        try {
            signature.append(Types.typeToString(clazz));
            signature.append('.');
            signature.append(name);
            if (params != null) {
                signature.append('(');
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        signature.append(", ");
                    }
                    signature.append(Types.typeToString(params[i]));
                }
                signature.append(')');
            } else {
                signature.append("<unknown parameters>");
            }
        }
        catch (Exception e) {
            signature.append("!!!<");
            signature.append(e);
            signature.append(">!!!");
        }
        return signature.toString();
    }

    public static String renderArrayConstructor(Class<?> clazz, Object[] params) {
        StringBuilder signature = new StringBuilder();
        try {
            signature.append(Types.typeToString(clazz));
            if (params != null) {
                signature.append('(');
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        signature.append(", ");
                    }
                    signature.append(params[i]);
                }
                signature.append(')');
            } else {
                signature.append("<unknown parameters>");
            }
        }
        catch (Exception e) {
            signature.append("!!!<");
            signature.append(e);
            signature.append(">!!!");
        }
        return signature.toString();
    }

    static {
        try {
            _classForNameMethod = Class.class.getMethod("forName", String.class);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            _classForNameMethod = null;
        }
    }
}

