/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.io;

import CH.ifa.draw.io.CombinationFileFilter;
import de.renew.navigator.io.FileFilterBuilder;
import de.renew.navigator.io.IOLoader;
import de.renew.navigator.io.ProgressListener;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.TreeElement;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class FilesystemIOLoader
implements IOLoader {
    private static final Logger LOGGER = Logger.getLogger(FilesystemIOLoader.class);
    private final FileFilterBuilder _fileFilterBuilder;

    public FilesystemIOLoader(FileFilterBuilder fileFilterBuilder) {
        this._fileFilterBuilder = fileFilterBuilder;
    }

    @Override
    public TreeElement loadPath(File path, ProgressListener listener) {
        TreeElement treeElement = this.createModel(path);
        if (treeElement instanceof Directory) {
            CombinationFileFilter fileFilter = this._fileFilterBuilder.buildFileFilter();
            Directory directory = (Directory)treeElement;
            this.classifyDirectory(directory, (FileFilter)fileFilter);
            directory.setOpened(true);
            this.loadDirectory(directory, listener, (FileFilter)fileFilter);
        }
        return treeElement;
    }

    @Override
    public void refreshPath(TreeElement model, File path, ProgressListener listener) {
        if (model instanceof Directory) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("refreshing path: " + String.valueOf(path)));
            }
            Directory updatedModel = (Directory)this.loadPath(path, listener);
            this.compareDirectories((Directory)model, updatedModel, listener);
        }
    }

    private void loadDirectory(Directory parent, final ProgressListener listener, FileFilter fileFilter) {
        if (listener.isWorkerCancelled()) {
            return;
        }
        File[] files = parent.getFile().listFiles(fileFilter);
        if (files == null) {
            return;
        }
        final int filesCount = files.length;
        int progress = 0;
        this.sortFiles(files);
        for (File file : files) {
            if (!file.isDirectory() && file.isFile()) {
                Leaf fileModel = this.createFileModel(file);
                parent.add(fileModel);
                listener.progress(++progress, filesCount);
                continue;
            }
            Directory directoryModel = this.createDirectoryModel(file);
            parent.add(directoryModel);
            this.classifyDirectory(directoryModel, fileFilter);
            if (directoryModel.getType() == DirectoryType.PACKAGE) {
                File[] sub = file.listFiles(fileFilter);
                while (sub != null && sub.length == 1 && sub[0].isDirectory()) {
                    file = sub[0];
                    directoryModel.setFile(file);
                    String newName = directoryModel.getName() + "." + file.getName();
                    directoryModel.setName(newName);
                    sub = file.listFiles(fileFilter);
                }
            }
            final int currentProgress = progress++;
            ProgressListener childListener = new ProgressListener(){

                @Override
                public void progress(float progress, int max) {
                    listener.progress((float)currentProgress + progress / (float)max, filesCount);
                }

                @Override
                public boolean isWorkerCancelled() {
                    return listener.isWorkerCancelled();
                }
            };
            this.loadDirectory(directoryModel, childListener, fileFilter);
            listener.progress(progress, filesCount);
        }
    }

    private void sortFiles(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() && !o2.isDirectory()) {
                    return -1;
                }
                if (!o1.isDirectory() && o2.isDirectory()) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    private void compareDirectories(Directory oldModel, Directory newModel, ProgressListener listener) {
        if (listener.isWorkerCancelled()) {
            return;
        }
        LOGGER.debug((Object)("Comparing " + oldModel.getFile().getAbsolutePath()));
        LinkedList<TreeElement> childrenToRemove = new LinkedList<TreeElement>();
        for (TreeElement child : oldModel.getChildren()) {
            TreeElement newChild = this.findNewTreeElement(newModel, child);
            if (newChild == null) {
                childrenToRemove.add(child);
                continue;
            }
            newModel.remove(newChild);
            if (child instanceof Leaf) {
                if (newChild instanceof Leaf) continue;
                childrenToRemove.add(child);
                oldModel.add(newChild);
                continue;
            }
            if (!(child instanceof Directory)) continue;
            if (newChild instanceof Directory) {
                this.compareDirectories((Directory)child, (Directory)newChild, listener);
                continue;
            }
            childrenToRemove.add(child);
            oldModel.add(newChild);
        }
        for (TreeElement child : newModel.getChildren()) {
            LOGGER.debug((Object)("New Child: " + String.valueOf(child)));
            oldModel.add(child);
        }
        for (TreeElement child : childrenToRemove) {
            LOGGER.debug((Object)("Removed Child: " + String.valueOf(child)));
            oldModel.remove(child);
        }
    }

    private TreeElement findNewTreeElement(Directory newModel, TreeElement child) {
        TreeElement newChild = null;
        for (TreeElement c : newModel.getChildren()) {
            if (!child.getFile().equals(c.getFile())) continue;
            newChild = c;
        }
        return newChild;
    }

    private TreeElement createModel(File file) {
        if (file.isDirectory()) {
            return this.createDirectoryModel(file);
        }
        return this.createFileModel(file);
    }

    private Directory createDirectoryModel(File dir) {
        Directory model = new Directory();
        model.setOpened(false);
        model.setFile(dir);
        model.setName(dir.getName());
        model.setExcluded(false);
        return model;
    }

    private Leaf createFileModel(File file) {
        Leaf model = new Leaf();
        model.setFile(file);
        model.setName(file.getName());
        model.setExcluded(false);
        return model;
    }

    private void classifyDirectory(Directory directory, FileFilter fileFilter) {
        boolean containsPluginCFG;
        DirectoryType parentType = directory.getParent() == null || directory.getParent() instanceof NavigatorFileTree ? null : ((Directory)directory.getParent()).getType();
        if (parentType == DirectoryType.SOURCE || parentType == DirectoryType.PACKAGE || parentType == DirectoryType.TEST_SOURCE) {
            directory.setType(DirectoryType.PACKAGE);
            return;
        }
        if (parentType == DirectoryType.PLUGIN) {
            String name = directory.getFile().getName();
            if (name.equals("src") || name.equals("resources")) {
                directory.setType(DirectoryType.SOURCE);
                return;
            }
            if (name.equals("test") || name.equals("testsrc") || name.equals("testing")) {
                directory.setType(DirectoryType.TEST_SOURCE);
                return;
            }
            if (name.equals("etc")) {
                directory.setType(DirectoryType.ETC);
                return;
            }
            return;
        }
        File currentFile = directory.getFile();
        boolean bl = containsPluginCFG = currentFile != null && new File(currentFile.getPath().concat("/src/main/resources/plugin.cfg")).isFile();
        if (parentType == null && containsPluginCFG) {
            directory.setType(DirectoryType.PLUGIN);
        }
    }
}

