/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import CH.ifa.draw.util.Iconkit;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.models.TreeElement;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public abstract class FileTreeCellRenderer
implements TreeCellRenderer {
    private static final int ICON_SIZE = 16;
    private final LinkedList<FileTreeCellRenderer> _additionalRenderers = new LinkedList();
    private final DefaultTreeCellRenderer _cellRenderer = new DefaultTreeCellRenderer();

    public abstract void render(DefaultTreeCellRenderer var1, TreeElement var2, boolean var3, boolean var4);

    @Override
    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean hasFocus) {
        this._cellRenderer.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, hasFocus);
        this._cellRenderer.setFont(tree.getFont());
        if (!(value instanceof FileTreeNode)) {
            return this._cellRenderer;
        }
        TreeElement element = ((FileTreeNode)value).getModel();
        this.render(this._cellRenderer, element, sel, exp);
        for (FileTreeCellRenderer renderer : this._additionalRenderers) {
            renderer.render(this._cellRenderer, element, sel, exp);
        }
        return this._cellRenderer;
    }

    public void addAdditionalRenderer(FileTreeCellRenderer additionalRenderer) {
        this._additionalRenderers.add(additionalRenderer);
    }

    public void removeAdditionalRenderer(FileTreeCellRenderer additionalRenderer) {
        this._additionalRenderers.remove(additionalRenderer);
    }

    protected static Icon loadIcon(String filename) {
        return new ImageIcon(Iconkit.instance().loadImage(filename).getScaledInstance(16, 16, 4));
    }

    protected static void applyIcon(JLabel label, String filename) {
        label.setIcon(FileTreeCellRenderer.loadIcon(filename));
    }
}

