/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ShadowNet
implements Serializable {
    static final long serialVersionUID = 5180248532101141649L;
    public transient Object context = null;
    private Set<ShadowNetElement> elements = new HashSet<ShadowNetElement>();
    private String name;
    private ShadowCompilerFactory compilerFactory;
    private ShadowNetSystem netSystem;

    public ShadowNet(String name, ShadowNetSystem netSystem) {
        this.name = name;
        this.netSystem = netSystem;
        netSystem.add(this);
    }

    public ShadowCompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(ShadowCompilerFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }

    private ShadowCompiler createShadowNetCompiler() throws SyntaxException {
        if (this.compilerFactory != null) {
            return this.compilerFactory.createCompiler();
        }
        if (this.netSystem.getDefaultCompilerFactory() != null) {
            return this.netSystem.getDefaultCompilerFactory().createCompiler();
        }
        throw new SyntaxException("No compiler or default compiler set for net " + this.getName(), new String[0]);
    }

    ShadowCompiler createInititalizedShadowNetCompiler(ShadowLookup lookup) throws SyntaxException {
        ShadowCompiler compiler = this.createShadowNetCompiler();
        compiler.set_loopbackNetLoader(this.netSystem.createNetLoader(lookup));
        compiler.setShadowLookup(lookup);
        return compiler;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<ShadowNetElement> elements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public void discard() {
        this.netSystem.remove(this);
    }

    public void switchNetSystem(ShadowNetSystem newNetSystem) {
        ShadowCompilerFactory currentFactory = this.getCompilerFactory();
        if (currentFactory == null && (currentFactory = this.netSystem.getDefaultCompilerFactory()) != null && !currentFactory.equals(newNetSystem.getDefaultCompilerFactory())) {
            this.setCompilerFactory(currentFactory);
        }
        this.netSystem.remove(this);
        this.netSystem = newNetSystem;
        this.netSystem.add(this);
        if (currentFactory != null && currentFactory.equals(this.netSystem.getDefaultCompilerFactory())) {
            this.setCompilerFactory(null);
        }
    }

    void add(ShadowNetElement element) {
        this.elements.add(element);
    }

    void remove(ShadowNetElement element) {
        this.elements.remove(element);
        element.context = null;
    }

    public String toString() {
        return "ShadowNet \"" + this.name + "\" (" + this.elements.size() + " elements)";
    }

    public String checkDeclarationNode(String newText, boolean special) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkDeclarationNode(newText, special, this);
    }

    public String checkTransitionInscription(String inscr, boolean special) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkTransitionInscription(inscr, special, this);
    }

    public String checkPlaceInscription(String newText, boolean special) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkPlaceInscription(newText, special, this);
    }

    public String checkArcInscription(String newText, boolean special) throws SyntaxException {
        return this.createInititalizedShadowNetCompiler(new ShadowLookup()).checkArcInscription(newText, special, this);
    }
}

